/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp;

import dragon.nlp.Concept;
import dragon.nlp.Sentence;

public class Word {
    public static final int SUBJ = 1;
    public static final int PREDICATE = 2;
    public static final int OBJ = 3;
    public static final int TYPE_WORD = 1;
    public static final int TYPE_NUMBER = 2;
    public static final int TYPE_PUNC = 4;
    public Word next = null;
    public Word prev = null;
    private Sentence parent = null;
    private String content;
    private String lemma;
    private boolean isBaseForm;
    private boolean ignored;
    private String posLabel = null;
    private int freq = 1;
    private int index;
    private int offset = -1;
    private byte posIndex;
    private byte types;
    private byte posInSentence = (byte)-1;
    private byte roleInClause = (byte)-1;
    private byte parallelGroup;
    private byte clauseID;
    private Concept associatedConcept = null;

    public Word(String content) {
        this.posIndex = (byte)-1;
        this.content = content;
        this.lemma = null;
        this.ignored = false;
        this.isBaseForm = false;
        this.types = 1;
        this.parallelGroup = (byte)-1;
        this.parent = null;
        this.clauseID = (byte)-1;
        this.index = Integer.MIN_VALUE;
    }

    public Word copy() {
        Word newWord = new Word(this.content);
        newWord.setLemma(this.getLemma());
        newWord.setPOS(this.getPOSLabel(), this.getPOSIndex());
        newWord.setParallelGroup(this.getParallelGroup());
        newWord.setRoleInClause(this.getRoleInClause());
        newWord.setIndex(this.getIndex());
        newWord.setAssociatedConcept(this.getAssociatedConcept());
        return newWord;
    }

    public String getName() {
        if (this.getLemma() != null) {
            return this.getLemma();
        }
        return this.content;
    }

    public String getEntryID() {
        return null;
    }

    public String getSemanticType() {
        return null;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setLemma(String lemma) {
        if (lemma == null) {
            this.lemma = null;
            this.isBaseForm = false;
            return;
        }
        if ((lemma = lemma.toLowerCase()).compareTo(this.content) == 0) {
            lemma = null;
            this.isBaseForm = true;
        } else {
            this.isBaseForm = false;
            this.lemma = lemma;
        }
    }

    public String getLemma() {
        if (this.isBaseForm) {
            return this.content;
        }
        return this.lemma;
    }

    public Sentence getParent() {
        return this.parent;
    }

    public void setParent(Sentence parent) {
        this.parent = parent;
    }

    public int getType() {
        return this.types;
    }

    public void setType(int wordType) {
        if (wordType == 2 || wordType == 4) {
            this.types = (byte)wordType;
            this.isBaseForm = true;
        } else {
            this.types = 1;
        }
    }

    public int getPosInSentence() {
        return this.posInSentence;
    }

    public void setPosInSentence(int offset) {
        this.posInSentence = (byte)offset;
    }

    public boolean isNumber() {
        return this.types == 2;
    }

    public boolean isWord() {
        return this.types == 1;
    }

    public boolean isAllCapital() {
        return Character.isUpperCase(this.content.charAt(0)) && Character.isUpperCase(this.content.charAt(this.content.length() - 1));
    }

    public boolean isInitialCapital() {
        return Character.isUpperCase(this.content.charAt(0));
    }

    public int getParallelGroup() {
        return this.parallelGroup;
    }

    public void setParallelGroup(int groupNo) {
        this.parallelGroup = (byte)groupNo;
    }

    public int getClauseID() {
        return this.clauseID;
    }

    public void setClauseID(int clauseID) {
        this.clauseID = (byte)clauseID;
    }

    public boolean isPunctuation() {
        return this.types == 4;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setPOS(String posLabel, int posIndex) {
        this.posLabel = posLabel;
        this.posIndex = (byte)posIndex;
        if (posIndex <= 0 || posIndex == 8 || posIndex == 7 || posIndex == 5) {
            this.isBaseForm = true;
        }
    }

    public void setIgnore(boolean ignored) {
        this.ignored = ignored;
    }

    public boolean canIgnore() {
        return this.ignored;
    }

    public String getPOSLabel() {
        return this.posLabel;
    }

    public int getPOSIndex() {
        return this.posIndex;
    }

    public int getFrequency() {
        return this.freq;
    }

    public void addFrequency(int inc) {
        this.freq += inc;
    }

    public void setFrequency(int freq) {
        this.freq = freq;
    }

    public void setAssociatedConcept(Concept concept) {
        this.associatedConcept = concept;
    }

    public Concept getAssociatedConcept() {
        return this.associatedConcept;
    }

    public void setRoleInClause(int role) {
        this.roleInClause = (byte)role;
    }

    public int getRoleInClause() {
        return this.roleInClause;
    }

    public int hashCode() {
        if (this.index >= 0) {
            return this.index;
        }
        return super.hashCode();
    }
}

