/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp;

import dragon.nlp.Concept;
import dragon.nlp.compare.SortedElement;

public class Triple
implements Comparable,
SortedElement {
    private Concept first;
    private Concept second;
    private String rel;
    private String[] can_rel;
    private int freq;
    private int index;
    private double weight;
    private Object memo;

    public Triple(Concept first, Concept second) {
        this.first = first;
        this.second = second;
        this.rel = null;
        this.can_rel = null;
        this.freq = 1;
        this.weight = 0.0;
        this.memo = null;
    }

    public int compareTo(Object obj) {
        int objIndex = ((Triple)obj).getFirstConcept().getIndex();
        if (this.first.getIndex() == objIndex) {
            objIndex = ((Triple)obj).getSecondConcept().getIndex();
            if (this.second.getIndex() == objIndex) {
                return 0;
            }
            if (this.second.getIndex() > objIndex) {
                return 1;
            }
            return -1;
        }
        if (this.first.getIndex() > objIndex) {
            return 1;
        }
        return -1;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    public Object getMemo() {
        return this.memo;
    }

    public void setMemo(Object memo) {
        this.memo = memo;
    }

    public Concept getFirstConcept() {
        return this.first;
    }

    public Concept getSecondConcept() {
        return this.second;
    }

    public String getTUI() {
        return this.rel;
    }

    public void setTUI(String rel) {
        this.rel = rel;
    }

    public String[] getCandidateTUI() {
        return this.can_rel;
    }

    public String getCandidateTUI(int index) {
        return this.can_rel[index];
    }

    public int getCandidateTUINum() {
        if (this.can_rel == null) {
            return 0;
        }
        return this.can_rel.length;
    }

    public void setCandidateTUI(String[] can_rel) {
        this.can_rel = can_rel;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public int getFrequency() {
        return this.freq;
    }

    @Override
    public void setFrequency(int freq) {
        this.freq = freq;
    }

    public void addFrequency(int inc) {
        this.freq += inc;
    }

    public boolean equalTo(Triple triple) {
        return this.first.equalTo(triple.getFirstConcept()) && this.second.equalTo(triple.getSecondConcept()) || this.first.equalTo(triple.getSecondConcept()) && this.second.equalTo(triple.getFirstConcept());
    }
}

