/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp;

import dragon.nlp.Concept;
import dragon.nlp.Word;
import dragon.nlp.compare.SortedElement;

public class Token
implements Concept,
Comparable,
SortedElement {
    private String value;
    private int index;
    private int freq;
    private double weight;
    private Object memo;

    public Token(String value) {
        this.freq = 1;
        this.value = value;
        this.index = -1;
        this.weight = -1.0;
        this.memo = null;
    }

    public Token(int index, int frequency) {
        this.freq = frequency;
        this.index = index;
        this.weight = -1.0;
        this.value = null;
        this.memo = null;
    }

    public Token(String value, int index, int frequency) {
        this.freq = frequency;
        this.value = value;
        this.index = index;
        this.weight = -1.0;
        this.memo = null;
    }

    @Override
    public Concept copy() {
        Token cur = new Token(this.value);
        cur.setFrequency(this.freq);
        cur.setIndex(this.index);
        cur.setWeight(this.weight);
        return cur;
    }

    @Override
    public int getConceptType() {
        return 3;
    }

    @Override
    public String getName() {
        return this.value;
    }

    @Override
    public String getEntryID() {
        return this.value;
    }

    @Override
    public String getSemanticType() {
        return null;
    }

    @Override
    public boolean isSubConcept() {
        return false;
    }

    @Override
    public Word getStartingWord() {
        return null;
    }

    @Override
    public Word getEndingWord() {
        return null;
    }

    @Override
    public Object getMemo() {
        return this.memo;
    }

    @Override
    public void setMemo(Object memo) {
        this.memo = memo;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public void setFrequency(int freq) {
        this.freq = freq;
    }

    @Override
    public void addFrequency(int inc) {
        this.freq += inc;
    }

    @Override
    public int getFrequency() {
        return this.freq;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public int compareTo(Object obj) {
        String objValue = ((Token)obj).getValue();
        return this.value.compareToIgnoreCase(objValue);
    }

    public int compareTo(Token token) {
        return this.value.compareToIgnoreCase(token.getValue());
    }

    public boolean equals(Object obj) {
        if (this.value == null) {
            return this.index == ((Concept)obj).getIndex();
        }
        return this.value.equalsIgnoreCase(((Concept)obj).getName());
    }

    @Override
    public boolean equalTo(Concept concept) {
        if (this.value == null) {
            return this.index == concept.getIndex();
        }
        return this.value.equalsIgnoreCase(concept.getName());
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        if (this.index >= 0) {
            return this.index;
        }
        return super.hashCode();
    }
}

