/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp;

import dragon.nlp.SimplePair;
import dragon.nlp.compare.IndexComparator;
import dragon.util.FastBinaryReader;
import dragon.util.FastBinaryWriter;
import dragon.util.SortedArray;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;

public class SimplePairList {
    private SortedArray keyList;
    private SortedArray indexList;
    private boolean writingMode;
    private String keylistFilename;

    public SimplePairList() {
        this.keyList = new SortedArray();
        this.keylistFilename = null;
        this.writingMode = true;
    }

    public SimplePairList(String filename, boolean writingMode) {
        this.writingMode = writingMode;
        this.keylistFilename = filename;
        this.keyList = this.loadRelationKeyList(filename);
        if (!writingMode) {
            this.indexList = this.keyList.copy(new IndexComparator());
        }
    }

    public int add(int firstElement, int secondElement) {
        if (!this.writingMode) {
            return -1;
        }
        SimplePair pair = new SimplePair(this.keyList.size(), firstElement, secondElement);
        if (!this.keyList.add(pair)) {
            pair = (SimplePair)this.keyList.get(this.keyList.insertedPos());
        }
        return pair.getIndex();
    }

    public int search(int firstElement, int secondElement) {
        int pos = this.keyList.binarySearch(new SimplePair(0, firstElement, secondElement));
        if (pos >= 0) {
            return ((SimplePair)this.keyList.get(pos)).getIndex();
        }
        return -1;
    }

    public SimplePair get(int index) {
        if (this.indexList == null) {
            if (this.keylistFilename == null) {
                this.writingMode = false;
                this.indexList = this.keyList.copy(new IndexComparator());
            } else {
                return null;
            }
        }
        return (SimplePair)this.indexList.get(index);
    }

    public int size() {
        return this.keyList.size();
    }

    public void close() {
        if (this.writingMode) {
            this.saveRelationKeyList(this.keylistFilename, this.keyList);
        }
        this.keyList.clear();
    }

    private SortedArray loadRelationKeyList(String filename) {
        try {
            File file = new File(filename);
            if (!file.exists()) {
                return new SortedArray();
            }
            System.out.println(new Date() + " Loading Pair List...");
            FastBinaryReader br = new FastBinaryReader(filename);
            int total = br.readInt();
            ArrayList<SimplePair> list = new ArrayList<SimplePair>(total);
            for (int i = 0; i < total; ++i) {
                SimplePair cur = new SimplePair(br.readInt(), br.readInt(), br.readInt());
                list.add(cur);
            }
            br.close();
            SortedArray relationList = new SortedArray();
            relationList.addAll(list);
            return relationList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void saveRelationKeyList(String filename, ArrayList list) {
        try {
            if (list == null) {
                return;
            }
            System.out.println(new Date() + " Saving Pair List...");
            FastBinaryWriter fbw = new FastBinaryWriter(filename);
            fbw.writeInt(list.size());
            for (int i = 0; i < list.size(); ++i) {
                SimplePair cur = (SimplePair)list.get(i);
                fbw.writeInt(cur.getIndex());
                fbw.writeInt(cur.getFirstElement());
                fbw.writeInt(cur.getSecondElement());
                if (i % 100000 != 0) continue;
                fbw.flush();
            }
            fbw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

