/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp;

import dragon.nlp.SimpleElement;
import dragon.nlp.compare.IndexComparator;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;

public class SimpleElementList {
    private SortedArray keyList;
    private SortedArray indexList;
    private boolean writingMode;
    private boolean continuousIndex;
    private String keylistFilename;

    public SimpleElementList() {
        this.keylistFilename = null;
        this.keyList = new SortedArray();
        this.writingMode = true;
    }

    public SimpleElementList(String filename, boolean writingMode) {
        this.writingMode = writingMode;
        this.keylistFilename = filename;
        this.keyList = this.loadKeyList(filename);
        if (!writingMode) {
            this.indexList = this.keyList.copy(new IndexComparator());
            this.continuousIndex = this.indexList.size() == 0 || this.indexList.size() == ((SimpleElement)this.indexList.get(this.indexList.size() - 1)).getIndex() + 1;
        }
    }

    public boolean isWritingMode() {
        return this.writingMode;
    }

    public int add(String key) {
        if (!this.writingMode) {
            return -1;
        }
        SimpleElement term = new SimpleElement(new String(key), this.keyList.size());
        if (!this.keyList.add(term)) {
            term = (SimpleElement)this.keyList.get(this.keyList.insertedPos());
        }
        return term.getIndex();
    }

    public boolean add(SimpleElement element) {
        if (!this.writingMode) {
            return false;
        }
        return this.keyList.add(element);
    }

    public int search(String key) {
        int pos = this.keyList.binarySearch(new SimpleElement(key, -1));
        if (pos >= 0) {
            return ((SimpleElement)this.keyList.get(pos)).getIndex();
        }
        return -1;
    }

    public String search(int index) {
        if (this.indexList == null) {
            if (this.keylistFilename == null) {
                this.writingMode = false;
                this.indexList = this.keyList.copy(new IndexComparator());
                this.continuousIndex = this.indexList.size() == ((SimpleElement)this.indexList.get(this.indexList.size() - 1)).getIndex() + 1;
            } else {
                return null;
            }
        }
        if (this.continuousIndex) {
            return ((SimpleElement)this.indexList.get(index)).getKey();
        }
        int pos = this.indexList.binarySearch(new SimpleElement(null, index));
        if (pos >= 0) {
            return ((SimpleElement)this.indexList.get(pos)).getKey();
        }
        return null;
    }

    public boolean contains(String key) {
        return this.keyList.contains(new SimpleElement(key, -1));
    }

    public int size() {
        return this.keyList.size();
    }

    public void close() {
        if (this.writingMode && this.keylistFilename != null) {
            this.saveKeyList(this.keylistFilename, this.keyList);
        }
        if (this.keyList != null) {
            this.keyList.clear();
        }
        if (this.indexList != null) {
            this.indexList.clear();
        }
    }

    private void saveKeyList(String filename, ArrayList list) {
        try {
            if (list == null) {
                return;
            }
            System.out.println(new Date() + " Saving Element List...");
            BufferedWriter bw = FileUtil.getTextWriter(filename);
            bw.write(list.size() + "");
            bw.write("\n");
            for (int i = 0; i < list.size(); ++i) {
                SimpleElement cur = (SimpleElement)list.get(i);
                bw.write(cur.getKey() + "\t" + cur.getIndex() + "\n");
                bw.flush();
            }
            bw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private SortedArray loadKeyList(String filename) {
        try {
            File file = new File(filename);
            if (!file.exists()) {
                return new SortedArray();
            }
            System.out.println(new Date() + " Loading Element List...");
            BufferedReader br = FileUtil.getTextReader(filename);
            String line = br.readLine();
            String[] arrField = line.split("\t");
            int total = Integer.parseInt(arrField[0]);
            ArrayList<SimpleElement> list = new ArrayList<SimpleElement>(total);
            for (int i = 0; i < total; ++i) {
                line = br.readLine();
                arrField = line.split("\t");
                list.add(new SimpleElement(arrField[0], Integer.parseInt(arrField[arrField.length - 1])));
            }
            br.close();
            Collections.sort(list);
            SortedArray termList = new SortedArray();
            termList.addAll(list);
            return termList;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

