/*
 * Decompiled with CFR 0.152.
 */
package dragon.nlp;

import dragon.nlp.Paragraph;
import dragon.nlp.Word;

public class Sentence {
    public Sentence next = null;
    public Sentence prev = null;
    private Paragraph parent = null;
    private Word start = null;
    private Word end = null;
    private int count = 0;
    private int index = -1;
    private char m_punctuation;
    private Word subjStart = null;
    private Word subjEnd = null;

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public Paragraph getParent() {
        return this.parent;
    }

    public void setParent(Paragraph parent) {
        this.parent = parent;
    }

    public void setPunctuation(char punctuation) {
        this.m_punctuation = punctuation;
    }

    public char getPunctuation() {
        return this.m_punctuation;
    }

    public int getWordNum() {
        return this.count;
    }

    public Word getWord(int index) {
        if (index < 0 || index >= this.count) {
            return null;
        }
        Word cur = this.start;
        for (int curPos = 0; curPos < index; ++curPos) {
            cur = cur.next;
        }
        return cur;
    }

    public Word getFirstWord() {
        return this.start;
    }

    public void resetBoundary(Word start, Word end) {
        this.start = start;
        start.prev = null;
        this.end = end;
        end.next = null;
        this.count = 0;
        while (start != null) {
            start.setParent(this);
            start.setPosInSentence(this.count);
            ++this.count;
            start = start.next;
        }
    }

    public Word getLastWord() {
        return this.end;
    }

    public boolean addWord(Word cur) {
        if (cur == null) {
            return false;
        }
        cur.setParent(this);
        if (this.end != null) {
            this.end.next = cur;
        }
        if (this.start == null) {
            this.start = cur;
        }
        cur.prev = this.end;
        cur.next = null;
        cur.setPosInSentence(this.count);
        this.end = cur;
        ++this.count;
        return true;
    }

    public String toLinkGrammarString() {
        StringBuffer str = new StringBuffer();
        Word word = this.getFirstWord();
        while (word != null) {
            str.append(word.getContent());
            str.append(' ');
            word = word.next;
        }
        str.setCharAt(str.length() - 1, this.getPunctuation());
        return str.toString();
    }

    public String toPOSTaggedString() {
        StringBuffer str = new StringBuffer();
        Word word = this.getFirstWord();
        while (word != null) {
            str.append(word.getContent());
            str.append('/');
            str.append(word.getPOSLabel());
            str.append(' ');
            word = word.next;
        }
        str.setCharAt(str.length() - 1, this.getPunctuation());
        return str.toString();
    }

    public String toBrillTaggerString() {
        StringBuffer str = new StringBuffer();
        Word word = this.getFirstWord();
        while (word != null) {
            str.append(word.getContent());
            str.append(' ');
            word = word.next;
        }
        str.append(this.getPunctuation());
        return str.toString();
    }

    public String toString() {
        Word word = this.getFirstWord();
        if (word == null) {
            return null;
        }
        StringBuffer str = new StringBuffer(word.getContent());
        Word last = word;
        word = word.next;
        while (word != null) {
            if (word.isPunctuation()) {
                str.append(word.getContent());
            } else if (last.isPunctuation()) {
                if ("-_".indexOf(last.getContent()) >= 0) {
                    str.append(word.getContent());
                } else if (".'".lastIndexOf(last.getContent()) >= 0 && word.getContent().length() <= 2) {
                    str.append(word.getContent());
                } else {
                    str.append(' ');
                    str.append(word.getContent());
                }
            } else {
                str.append(' ');
                str.append(word.getContent());
            }
            last = word;
            word = word.next;
        }
        str.append(this.getPunctuation());
        return str.toString();
    }

    public Word getFirstSubjectWord() {
        return this.subjStart;
    }

    public Word getLastSubjectWord() {
        return this.subjEnd;
    }

    public void setSubject(Word starting, Word ending) {
        this.subjStart = starting;
        this.subjEnd = ending;
    }

    public Word indexOf(Word word) {
        return this.indexOf(word.getContent(), 0);
    }

    public Word indexOf(Word word, int start) {
        return this.indexOf(word.getContent(), start);
    }

    public Word indexOf(String word) {
        return this.indexOf(word, 0);
    }

    public Word indexOf(String word, int start) {
        Word next = this.getWord(start);
        while (next != null && !next.getContent().equalsIgnoreCase(word)) {
            next = next.next;
        }
        if (next != null) {
            return next;
        }
        return null;
    }
}

