/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.model;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.model.AbstractModel;
import dragon.ml.seqmodel.model.CompleteModel;
import dragon.ml.seqmodel.model.Edge;
import dragon.ml.seqmodel.model.EdgeIterator;
import dragon.ml.seqmodel.model.GenericModel;
import dragon.ml.seqmodel.model.ModelGraph;
import dragon.ml.seqmodel.model.NoEdgeModel;
import java.util.StringTokenizer;

public class NestedModel
extends AbstractModel {
    private int _numStates;
    private int _numEdges;
    private int[] nodeOffsets;
    private ModelGraph[] inner;
    private ModelGraph outer;
    private int[] startStates;
    private int[] endStates;

    public static void main(String[] args) {
        try {
            System.out.println(args[0]);
            System.out.println(args[1]);
            NestedModel model = new NestedModel(Integer.parseInt(args[0]), args[1]);
            System.out.println(((AbstractModel)model).getStateNum());
            System.out.println(model.getEdgeNum());
            System.out.println(model.getStartStateNum());
            System.out.println(model.getEndStateNum());
            EdgeIterator edgeIter = model.getEdgeIterator();
            int edgeNum = 0;
            while (edgeIter.hasNext()) {
                boolean edgeIsOuter = edgeIter.nextIsOuter();
                Edge e = edgeIter.next();
                System.out.println(e.getStart() + "(" + model.getLabel(e.getStart()) + ") -> " + e.getEnd() + ":" + edgeIsOuter + ";");
                ++edgeNum;
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    public NestedModel(int labelNum, String specs) throws Exception {
        super(labelNum, "Nested");
        int j;
        int i;
        this.nodeOffsets = new int[this.numLabels];
        this.inner = new AbstractModel[this.numLabels];
        StringTokenizer start = new StringTokenizer(specs, ",");
        this.outer = this.getNewBaseModel(this.numLabels, start.nextToken());
        String commonStruct = null;
        for (i = 0; i < this.numLabels; ++i) {
            String thisStruct = commonStruct;
            if (thisStruct == null && (thisStruct = start.nextToken()).endsWith("*")) {
                commonStruct = thisStruct = thisStruct.substring(0, thisStruct.length() - 1);
            }
            this.inner[i] = new GenericModel(thisStruct, i);
        }
        this._numEdges = 0;
        this._numStates = 0;
        for (int l = 0; l < this.numLabels; ++l) {
            int n = l;
            this.nodeOffsets[n] = this.nodeOffsets[n] + this._numStates;
            this._numStates += this.inner[l].getStateNum();
            this._numEdges += this.inner[l].getEdgeNum();
        }
        EdgeIterator outerIter = this.outer.getEdgeIterator();
        while (outerIter.hasNext()) {
            Edge e = outerIter.next();
            this._numEdges += this.inner[e.getEnd()].getStartStateNum() * this.inner[e.getStart()].getEndStateNum();
        }
        int numStart = 0;
        for (i = 0; i < this.outer.getStartStateNum(); ++i) {
            numStart += this.inner[this.outer.getStartState(i)].getStartStateNum();
        }
        this.startStates = new int[numStart];
        int index = 0;
        for (i = 0; i < this.outer.getStartStateNum(); ++i) {
            for (j = 0; j < this.inner[this.outer.getStartState(i)].getStartStateNum(); ++j) {
                this.startStates[index++] = this.inner[this.outer.getStartState(i)].getStartState(j) + this.nodeOffsets[this.outer.getStartState(i)];
            }
        }
        int numEnd = 0;
        for (i = 0; i < this.outer.getEndStateNum(); ++i) {
            numEnd += this.inner[this.outer.getEndState(i)].getEndStateNum();
        }
        this.endStates = new int[numEnd];
        index = 0;
        for (i = 0; i < this.outer.getEndStateNum(); ++i) {
            for (j = 0; j < this.inner[this.outer.getEndState(i)].getEndStateNum(); ++j) {
                this.endStates[index++] = this.inner[this.outer.getEndState(i)].getEndState(j) + this.nodeOffsets[this.outer.getEndState(i)];
            }
        }
    }

    @Override
    public EdgeIterator getEdgeIterator() {
        return new NestedEdgeIterator(this);
    }

    public EdgeIterator innerEdgeIterator() {
        return new NestedEdgeIterator(this, false);
    }

    @Override
    public int getStateNum() {
        return this._numStates;
    }

    @Override
    public int getEdgeNum() {
        return this._numEdges;
    }

    @Override
    public int getLabel(int stateNum) {
        for (int i = 0; i < this.nodeOffsets.length; ++i) {
            if (stateNum >= this.nodeOffsets[i]) continue;
            return i - 1;
        }
        return this.nodeOffsets.length - 1;
    }

    @Override
    public int getStartStateNum() {
        return this.startStates.length;
    }

    @Override
    public int getEndStateNum() {
        return this.endStates.length;
    }

    @Override
    public int getStartState(int i) {
        return i < this.getStartStateNum() ? this.startStates[i] : -1;
    }

    @Override
    public int getEndState(int i) {
        return i < this.getEndStateNum() ? this.endStates[i] : -1;
    }

    @Override
    public boolean isEndState(int i) {
        for (int k = 0; k < this.endStates.length; ++k) {
            if (this.endStates[k] != i) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStartState(int i) {
        for (int k = 0; k < this.startStates.length; ++k) {
            if (this.startStates[k] != i) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mapStateToLabel(DataSequence dataSeq) {
        int dataLen = dataSeq.length();
        if (dataLen == 0) {
            return true;
        }
        int segStart = 0;
        int segEnd = 0;
        while (segStart < dataLen) {
            for (segEnd = segStart; segEnd < dataLen; ++segEnd) {
                if (this.getLabel(dataSeq.getLabel(segStart)) != this.getLabel(dataSeq.getLabel(segEnd))) {
                    --segEnd;
                    System.out.println("WARNING: label ending in a state not marked as a End-state");
                    break;
                }
                if (this.isEndState(dataSeq.getLabel(segEnd))) break;
            }
            if (segEnd == dataLen) {
                System.out.println("WARNING: End state not found until the last position");
                System.out.println(dataSeq);
                segEnd = dataLen - 1;
            }
            dataSeq.setSegment(segStart, segEnd, this.getLabel(dataSeq.getLabel(segStart)));
            segStart = segEnd + 1;
        }
        return true;
    }

    @Override
    public boolean mapLabelToState(DataSequence data) {
        if (data.length() == 0) {
            return true;
        }
        int lstart = 0;
        while (lstart < data.length()) {
            int lend = data.getSegmentEnd(lstart) + 1;
            if (lend == 0) {
                return false;
            }
            int label = data.getLabel(lstart);
            this.inner[label].mapLabelToState(data, lend - lstart, lstart);
            for (int k = lstart; k < lend; ++k) {
                data.setLabel(k, this.nodeOffsets[label] + data.getLabel(k));
            }
            lstart = lend;
        }
        return true;
    }

    private ModelGraph getNewBaseModel(int numLabels, String modelSpecs) throws Exception {
        if (modelSpecs.equalsIgnoreCase("naive") || modelSpecs.equalsIgnoreCase("semi-markov")) {
            return new CompleteModel(numLabels);
        }
        if (modelSpecs.equalsIgnoreCase("noEdge")) {
            return new NoEdgeModel(numLabels);
        }
        throw new Exception("Base model can be one of {naive, noEdge, semi-Markov}");
    }

    private class NestedEdgeIterator
    implements EdgeIterator {
        private NestedModel model;
        private int label;
        private Edge edge;
        private EdgeIterator[] edgeIter;
        private EdgeIterator outerEdgeIter;
        private Edge outerEdge;
        private boolean outerEdgesSent;
        private int index1;
        private int index2;
        private boolean sendOuter;

        public NestedEdgeIterator(NestedModel m) {
            this(m, true);
        }

        public NestedEdgeIterator(NestedModel m, boolean sendOuter) {
            this.model = m;
            this.edge = new Edge();
            this.edgeIter = new EdgeIterator[this.model.numLabels];
            for (int l = 0; l < this.model.numLabels; ++l) {
                this.edgeIter[l] = this.model.inner[l].getEdgeIterator();
            }
            this.outerEdgeIter = this.model.outer.getEdgeIterator();
            this.sendOuter = sendOuter;
            this.start();
        }

        @Override
        public void start() {
            this.label = 0;
            for (int l = 0; l < this.model.numLabels; ++l) {
                this.edgeIter[l].start();
            }
            this.outerEdgeIter.start();
            this.outerEdge = this.outerEdgeIter.next();
            this.outerEdgesSent = this.outerEdge == null || !this.sendOuter;
            this.index2 = 0;
            this.index1 = 0;
        }

        @Override
        public boolean hasNext() {
            return this.label < this.model.numLabels || !this.outerEdgesSent;
        }

        public Edge nextOuterEdge() {
            this.edge.setStart(this.model.inner[this.outerEdge.getStart()].getEndState(this.index1) + this.model.nodeOffsets[this.outerEdge.getStart()]);
            this.edge.setEnd(this.model.inner[this.outerEdge.getEnd()].getStartState(this.index2) + this.model.nodeOffsets[this.outerEdge.getEnd()]);
            ++this.index2;
            if (this.index2 == this.model.inner[this.outerEdge.getEnd()].getStartStateNum()) {
                this.index2 = 0;
                ++this.index1;
                if (this.index1 == this.model.inner[this.outerEdge.getStart()].getEndStateNum()) {
                    if (this.outerEdgeIter.hasNext()) {
                        this.outerEdge = this.outerEdgeIter.next();
                        this.index2 = 0;
                        this.index1 = 0;
                    } else {
                        this.outerEdgesSent = true;
                    }
                }
            }
            return this.edge;
        }

        public Edge nextInnerEdge() {
            Edge edgeToRet = this.edgeIter[this.label].next();
            this.edge.setStart(edgeToRet.getStart());
            this.edge.setEnd(edgeToRet.getEnd());
            this.edge.setStart(this.edge.getStart() + this.model.nodeOffsets[this.label]);
            this.edge.setEnd(this.edge.getEnd() + this.model.nodeOffsets[this.label]);
            if (!this.edgeIter[this.label].hasNext()) {
                ++this.label;
            }
            return this.edge;
        }

        @Override
        public Edge next() {
            if (!this.nextIsOuter()) {
                return this.nextInnerEdge();
            }
            return this.nextOuterEdge();
        }

        @Override
        public boolean nextIsOuter() {
            return this.label >= this.model.numLabels;
        }
    }
}

