/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.model;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.model.AbstractModel;
import dragon.ml.seqmodel.model.Edge;
import dragon.ml.seqmodel.model.EdgeIterator;
import java.util.StringTokenizer;

public class GenericModel
extends AbstractModel {
    private int _numStates;
    private Edge[] _edges;
    private int[] edgeStart;
    private int[] startStates;
    private int[] endStates;
    private int myLabel;

    public GenericModel(String spec, int thisLabel) throws Exception {
        super(1, spec);
        this.myLabel = thisLabel;
        if (spec.endsWith("-chain") || spec.endsWith("-long")) {
            int len;
            StringTokenizer tok = new StringTokenizer(spec, "-");
            this._numStates = len = Integer.parseInt(tok.nextToken());
            this.startStates = new int[1];
            this.startStates[0] = 0;
            this.edgeStart = new int[this._numStates];
            if (len == 1) {
                this._edges = new Edge[1];
                this._edges[0] = new Edge(0, 0);
                this.endStates = new int[1];
                this.endStates[0] = 0;
                this.edgeStart[0] = 0;
            } else {
                this._edges = new Edge[2 * (len - 1)];
                for (int i = 0; i < len - 1; ++i) {
                    this._edges[2 * i] = new Edge(i, i + 1);
                    this._edges[2 * i + 1] = new Edge(i, len - 1);
                    this.edgeStart[i] = 2 * i;
                }
                this._edges[this._edges.length - 1] = new Edge(len - 2, len - 2);
                this.endStates = new int[2];
                this.endStates[0] = 0;
                this.endStates[1] = len - 1;
            }
        } else if (spec.endsWith("parallel")) {
            StringTokenizer tok = new StringTokenizer(spec, "-");
            int len = Integer.parseInt(tok.nextToken());
            this._numStates = len * (len + 1) / 2;
            this._edges = new Edge[len * (len - 1) / 2 + 1];
            this.edgeStart = new int[this._numStates];
            this.startStates = new int[len];
            this.endStates = new int[len];
            int node = 0;
            int e = 0;
            for (int i = 0; i < len; ++i) {
                node += i;
                for (int j = 0; j < i; ++j) {
                    this._edges[e++] = new Edge(node + j, node + j + 1);
                    this.edgeStart[node + j] = e - 1;
                }
                this.startStates[i] = node;
                this.endStates[i] = node + i;
            }
            node += len;
            this._edges[e++] = new Edge(this._numStates - 2, this._numStates - 2);
        } else if (spec.equals("boundary")) {
            this._numStates = 4;
            this._edges = new Edge[4];
            this._edges[0] = new Edge(1, 2);
            this._edges[1] = new Edge(1, 3);
            this._edges[2] = new Edge(2, 2);
            this._edges[3] = new Edge(2, 3);
            this.startStates = new int[2];
            this.startStates[0] = 0;
            this.startStates[1] = 1;
            this.endStates = new int[2];
            this.endStates[0] = 0;
            this.endStates[1] = 3;
            this.edgeStart = new int[this._numStates];
            this.edgeStart[0] = 4;
            this.edgeStart[1] = 0;
            this.edgeStart[2] = 2;
            this.edgeStart[3] = 4;
        } else {
            throw new Exception("Unknown graph type: " + spec);
        }
    }

    @Override
    public int getLabel(int s) {
        return this.myLabel == -1 ? s : this.myLabel;
    }

    public GenericModel(int numNodes, int numEdges) throws Exception {
        super(numNodes, "");
        this._numStates = numNodes;
        this._edges = new Edge[numEdges];
    }

    @Override
    public int getStateNum() {
        return this._numStates;
    }

    @Override
    public int getEdgeNum() {
        return this._edges.length;
    }

    @Override
    public int getStartStateNum() {
        return this.startStates.length;
    }

    @Override
    public int getStartState(int i) {
        return i < this.getStartStateNum() ? this.startStates[i] : -1;
    }

    @Override
    public int getEndStateNum() {
        return this.endStates.length;
    }

    @Override
    public int getEndState(int i) {
        return i < this.getEndStateNum() ? this.endStates[i] : -1;
    }

    @Override
    public boolean isEndState(int i) {
        for (int k = 0; k < this.endStates.length; ++k) {
            if (this.endStates[k] != i) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStartState(int i) {
        for (int k = 0; k < this.startStates.length; ++k) {
            if (this.startStates[k] != i) continue;
            return true;
        }
        return false;
    }

    @Override
    public EdgeIterator getEdgeIterator() {
        return new GenericEdgeIterator(this._edges);
    }

    @Override
    public boolean mapLabelToState(DataSequence data, int len, int start) {
        for (int i = 0; i < this.getStartStateNum(); ++i) {
            if (!this.pathToEnd(data, this.getStartState(i), len - 1, start + 1)) continue;
            data.setLabel(start, this.getStartState(i));
            return true;
        }
        return false;
    }

    private boolean pathToEnd(DataSequence data, int s, int lenLeft, int start) {
        if (lenLeft == 0) {
            return this.isEndState(s);
        }
        for (int e = this.edgeStart[s]; e < this.getEdgeNum() && this._edges[e].getStart() == s; ++e) {
            int child = this._edges[e].getEnd();
            if (!this.pathToEnd(data, child, lenLeft - 1, start + 1)) continue;
            data.setLabel(start, child);
            return true;
        }
        return false;
    }

    private class GenericEdgeIterator
    implements EdgeIterator {
        private int edgeNum;
        private Edge[] edges;

        public GenericEdgeIterator(Edge[] e) {
            this.edges = e;
            this.start();
        }

        @Override
        public void start() {
            this.edgeNum = 0;
        }

        @Override
        public boolean hasNext() {
            return this.edgeNum < this.edges.length;
        }

        @Override
        public Edge next() {
            ++this.edgeNum;
            return this.edges[this.edgeNum - 1];
        }

        @Override
        public boolean nextIsOuter() {
            return true;
        }
    }
}

