/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.model;

import dragon.ml.seqmodel.model.AbstractModel;
import dragon.ml.seqmodel.model.Edge;
import dragon.ml.seqmodel.model.EdgeIterator;

public class CompleteModel
extends AbstractModel {
    private int markovOrder;
    private int originalLabelNum;

    public CompleteModel(int labelNum) {
        this(labelNum, 1);
    }

    public CompleteModel(int labelNum, int markovOrder) {
        super(labelNum, "Complete");
        this.numLabels = this.computeLabelNum(labelNum, markovOrder);
        this.markovOrder = markovOrder;
        this.originalLabelNum = labelNum;
    }

    @Override
    public int getOriginalLabelNum() {
        return this.originalLabelNum;
    }

    @Override
    public int getMarkovOrder() {
        return this.markovOrder;
    }

    @Override
    public int getLabel(int state) {
        return state;
    }

    @Override
    public int getEdgeNum() {
        return this.numLabels * this.numLabels;
    }

    @Override
    public int getStartStateNum() {
        return this.numLabels;
    }

    @Override
    public int getEndStateNum() {
        return this.numLabels;
    }

    @Override
    public int getStartState(int i) {
        if (i < this.getStartStateNum()) {
            return i;
        }
        return -1;
    }

    @Override
    public int getEndState(int i) {
        if (i < this.getEndStateNum()) {
            return i;
        }
        return -1;
    }

    @Override
    public boolean isEndState(int i) {
        return true;
    }

    @Override
    public boolean isStartState(int i) {
        return true;
    }

    @Override
    public EdgeIterator getEdgeIterator() {
        return new SingleEdgeIterator(this.getLabelNum());
    }

    private int computeLabelNum(int originalLabelNum, int markovOrder) {
        int labelNum = originalLabelNum;
        for (int i = 1; i < markovOrder; ++i) {
            labelNum *= originalLabelNum;
        }
        return labelNum;
    }

    private class SingleEdgeIterator
    implements EdgeIterator {
        private int labelNum;
        private Edge edge;
        private Edge edgeToReturn;

        public SingleEdgeIterator(int labelNum) {
            this.labelNum = labelNum;
            this.edge = new Edge();
            this.edgeToReturn = new Edge();
            this.start();
        }

        @Override
        public void start() {
            this.edge.setStart(0);
            this.edge.setEnd(0);
        }

        @Override
        public boolean hasNext() {
            return this.edge.getStart() < this.labelNum;
        }

        @Override
        public Edge next() {
            this.edgeToReturn.setStart(this.edge.getStart());
            this.edgeToReturn.setEnd(this.edge.getEnd());
            this.edge.setEnd(this.edge.getEnd() + 1);
            if (this.edge.getEnd() == this.labelNum) {
                this.edge.setEnd(0);
                this.edge.setStart(this.edge.getStart() + 1);
            }
            return this.edgeToReturn;
        }

        @Override
        public boolean nextIsOuter() {
            return true;
        }
    }
}

