/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.model;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.model.CompleteModel;
import dragon.ml.seqmodel.model.Edge;
import dragon.ml.seqmodel.model.EdgeIterator;
import dragon.ml.seqmodel.model.ModelGraph;
import dragon.ml.seqmodel.model.NestedModel;
import dragon.ml.seqmodel.model.NoEdgeModel;

public abstract class AbstractModel
implements ModelGraph {
    protected int numLabels;
    protected String name;

    public AbstractModel(int labelNum, String name) {
        this.numLabels = labelNum;
        this.name = name;
    }

    @Override
    public int getLabelNum() {
        return this.numLabels;
    }

    @Override
    public int getStateNum() {
        return this.numLabels;
    }

    @Override
    public int getOriginalLabelNum() {
        return this.numLabels;
    }

    @Override
    public int getMarkovOrder() {
        return 1;
    }

    @Override
    public boolean mapStateToLabel(DataSequence seq) {
        return true;
    }

    @Override
    public boolean mapLabelToState(DataSequence seq) {
        return true;
    }

    @Override
    public boolean mapLabelToState(DataSequence data, int len, int start) {
        return true;
    }

    public void printGraph() {
        int i;
        System.out.println("Numnodes = " + this.getStateNum() + " NumEdges " + this.getEdgeNum());
        EdgeIterator iter = this.getEdgeIterator();
        iter.start();
        while (iter.hasNext()) {
            Edge edge = iter.next();
            System.out.println(edge.getStart() + "-->" + edge.getEnd());
        }
        System.out.print("Start states");
        for (i = 0; i < this.getStartStateNum(); ++i) {
            System.out.print(" " + this.getStartState(i));
        }
        System.out.println("");
        System.out.print("End states");
        for (i = 0; i < this.getEndStateNum(); ++i) {
            System.out.print(" " + this.getEndState(i));
        }
        System.out.println("");
    }

    public static ModelGraph getNewModelGraph(int numLabels, String modelSpecs) {
        try {
            modelSpecs = modelSpecs.toLowerCase().trim();
            if (modelSpecs.equalsIgnoreCase("noEdge")) {
                return new NoEdgeModel(numLabels);
            }
            if (modelSpecs.equalsIgnoreCase("naive") || modelSpecs.equalsIgnoreCase("semi-markov")) {
                return new CompleteModel(numLabels);
            }
            if (modelSpecs.startsWith("naive") && modelSpecs.indexOf(44) < 0) {
                int markovOrder = Integer.parseInt(modelSpecs.substring(modelSpecs.indexOf(32) + 1));
                return new CompleteModel(numLabels, markovOrder);
            }
            return new NestedModel(numLabels, modelSpecs);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

