/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.AbstractFeatureType;
import dragon.ml.seqmodel.feature.BasicFeature;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureDictionary;
import dragon.ml.seqmodel.feature.FeatureIdentifier;
import dragon.ml.seqmodel.feature.FeatureTypeWord;

public class FeatureTypeUnknownWord
extends AbstractFeatureType {
    private int curState;
    private FeatureDictionary dict;
    private int stateNum;
    private boolean caseSensitive;

    public FeatureTypeUnknownWord(FeatureDictionary d) {
        this(d, false);
    }

    public FeatureTypeUnknownWord(FeatureDictionary d, boolean caseSensitive) {
        super(false);
        this.caseSensitive = caseSensitive;
        this.dict = d;
        this.idPrefix = "UW";
        this.stateNum = d.getStateNum();
    }

    @Override
    public boolean startScanFeaturesAt(DataSequence data, int startPos, int endPos) {
        int count;
        this.curState = this.stateNum;
        if (startPos != endPos) {
            System.out.println("The starting position and the ending position should be the same for unknown word features");
            return false;
        }
        if (data.getToken(endPos).getIndex() >= 0) {
            count = this.dict.getCount(data.getToken(endPos).getIndex());
        } else {
            String token = data.getToken(endPos).getContent();
            if (!this.caseSensitive) {
                token = token.toLowerCase();
            }
            count = this.dict.getCount(token);
        }
        if (count > FeatureTypeWord.RARE_THRESHOLD + 1) {
            return false;
        }
        this.curState = 0;
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.curState < this.stateNum;
    }

    @Override
    public Feature next() {
        FeatureIdentifier id = new FeatureIdentifier(this.idPrefix, this.curState, this.curState);
        BasicFeature f = new BasicFeature(id, this.curState, 1.0);
        ++this.curState;
        return f;
    }

    @Override
    public boolean supportSegment() {
        return false;
    }
}

