/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.AbstractFeatureTypeWrapper;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureIdentifier;
import dragon.ml.seqmodel.feature.FeatureType;

public class FeatureTypeStateLoop
extends AbstractFeatureTypeWrapper {
    private Feature nextFeature;
    int stateNum;
    int curState;
    boolean optimize = false;

    public FeatureTypeStateLoop(FeatureType ftype, int stateNum) {
        super(ftype);
        this.stateNum = stateNum;
    }

    boolean advance() {
        ++this.curState;
        if (this.curState < this.stateNum) {
            return true;
        }
        if (this.ftype.hasNext()) {
            this.nextFeature = this.ftype.next();
            this.curState = 0;
        }
        return this.curState < this.stateNum;
    }

    @Override
    public boolean startScanFeaturesAt(DataSequence data, int startPos, int endPos) {
        this.curState = this.stateNum;
        this.ftype.startScanFeaturesAt(data, startPos, endPos);
        return this.advance();
    }

    @Override
    public boolean hasNext() {
        return this.curState < this.stateNum;
    }

    @Override
    public Feature next() {
        Feature curFeature = this.nextFeature.copy();
        curFeature.setLabel(this.curState);
        FeatureIdentifier id = curFeature.getID();
        id.setState(this.curState);
        id.setId(id.getId() * this.stateNum + this.curState);
        this.advance();
        return curFeature;
    }
}

