/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.AbstractFeatureType;
import dragon.ml.seqmodel.feature.BasicFeature;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureIdentifier;

public class FeatureTypeSegmentLength
extends AbstractFeatureType {
    protected int segLen;
    protected int maxLen;

    public FeatureTypeSegmentLength() {
        super(false);
        this.maxLen = Integer.MAX_VALUE;
    }

    public FeatureTypeSegmentLength(int maxSegmentLength) {
        super(false);
        this.maxLen = maxSegmentLength;
    }

    @Override
    public boolean startScanFeaturesAt(DataSequence data, int pos) {
        return this.startScanFeaturesAt(data, pos, pos);
    }

    @Override
    public boolean startScanFeaturesAt(DataSequence data, int startPos, int endPos) {
        this.segLen = Math.min(endPos + 1 - startPos, this.maxLen);
        return true;
    }

    @Override
    public boolean hasNext() {
        return this.segLen > 0;
    }

    @Override
    public Feature next() {
        int curState = -1;
        String name = "Length" + (this.segLen == this.maxLen ? ">=" : "=") + this.segLen;
        FeatureIdentifier id = new FeatureIdentifier(name, this.segLen, curState);
        BasicFeature f = new BasicFeature(id, curState, 1.0);
        this.segLen = 0;
        return f;
    }
}

