/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.AbstractFeatureTypeWrapper;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureIdentifier;
import dragon.ml.seqmodel.feature.FeatureType;

public class FeatureTypePosition
extends AbstractFeatureTypeWrapper {
    private Feature savedFeature;
    private boolean squareSent;
    private int segStart;
    private int segEnd;
    private int currPos;
    private transient DataSequence dataSeq;

    public FeatureTypePosition(FeatureType ftype) {
        super(ftype);
    }

    private void advance() {
        while (!this.ftype.hasNext()) {
            ++this.currPos;
            if (this.currPos > this.segEnd) {
                return;
            }
            this.ftype.startScanFeaturesAt(this.dataSeq, this.currPos, this.currPos);
        }
        return;
    }

    public boolean startScanFeaturesAt(DataSequence data, int pos) {
        return this.startScanFeaturesAt(data, pos, pos);
    }

    @Override
    public boolean startScanFeaturesAt(DataSequence data, int startPos, int endPos) {
        this.segStart = startPos;
        this.segEnd = endPos;
        this.currPos = startPos;
        this.squareSent = true;
        this.dataSeq = data;
        this.ftype.startScanFeaturesAt(data, startPos, startPos);
        this.advance();
        return this.ftype.hasNext();
    }

    @Override
    public boolean hasNext() {
        return !this.squareSent || this.currPos <= this.segEnd && this.ftype.hasNext();
    }

    @Override
    public Feature next() {
        if (!this.squareSent) {
            this.squareSent = true;
            this.savedFeature.setValue(this.savedFeature.getValue() * this.savedFeature.getValue());
            FeatureIdentifier id = this.savedFeature.getID();
            id.setName("POS^2" + id.getName());
            id.setId(id.getId() * 2 + 1);
            this.advance();
            return this.savedFeature;
        }
        Feature f = this.ftype.next();
        f.setValue((this.currPos - this.segStart + 1) / (this.segEnd - this.segStart + 1));
        this.savedFeature = f.copy();
        this.squareSent = false;
        FeatureIdentifier id = f.getID();
        id.setName("POS_" + id.getName());
        id.setId(id.getId() * 2);
        return f;
    }
}

