/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.AbstractFeatureType;
import dragon.ml.seqmodel.feature.BasicFeature;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureIdentifier;
import dragon.ml.seqmodel.model.Edge;
import dragon.ml.seqmodel.model.EdgeIterator;
import dragon.ml.seqmodel.model.ModelGraph;

public class FeatureTypeEdge
extends AbstractFeatureType {
    private ModelGraph model;
    private EdgeIterator edgeIter;
    private int curEdgeIndex;

    public FeatureTypeEdge(ModelGraph model) {
        super(false);
        this.model = model;
        this.edgeIter = null;
    }

    @Override
    public boolean startScanFeaturesAt(DataSequence data, int startPos, int endPos) {
        if (startPos <= 0) {
            this.curEdgeIndex = this.model.getEdgeNum();
            return false;
        }
        this.curEdgeIndex = 0;
        this.edgeIter = this.model.getEdgeIterator();
        if (this.edgeIter != null) {
            this.edgeIter.start();
        }
        return this.hasNext();
    }

    @Override
    public boolean hasNext() {
        return this.edgeIter != null && this.curEdgeIndex < this.model.getEdgeNum();
    }

    @Override
    public Feature next() {
        boolean edgeIsOuter = this.edgeIter.nextIsOuter();
        Edge e = this.edgeIter.next();
        String name = "E." + this.model.getLabel(e.getStart());
        FeatureIdentifier id = edgeIsOuter ? new FeatureIdentifier(name, this.model.getLabel(e.getStart()) * this.model.getLabelNum() + this.model.getLabel(e.getEnd()) + this.model.getEdgeNum(), this.model.getLabel(e.getEnd())) : new FeatureIdentifier(name, this.curEdgeIndex, e.getEnd());
        BasicFeature f = new BasicFeature(id, e.getStart(), e.getEnd(), 1.0);
        ++this.curEdgeIndex;
        return f;
    }
}

