/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.feature.AbstractFeatureDictionary;
import dragon.ml.seqmodel.feature.FeatureDictionary;
import dragon.util.MathUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class FeatureDictionaryNum
extends AbstractFeatureDictionary
implements FeatureDictionary {
    private Hashtable dictionary;

    public FeatureDictionaryNum(int stateNum, int capacity) {
        super(stateNum);
        this.dictionary = new Hashtable(capacity);
        this.finalized = false;
    }

    @Override
    public int getIndex(Object feature) {
        HEntry entry = (HEntry)this.dictionary.get(feature);
        if (entry == null) {
            return -1;
        }
        return entry.getIndex();
    }

    @Override
    public boolean contain(Object feature) {
        return this.dictionary.get(feature) != null;
    }

    @Override
    public int size() {
        return this.dictionary.size();
    }

    @Override
    public int addFeature(Object feature, int label) {
        if (label < 0 || this.finalized) {
            return -1;
        }
        HEntry index = (HEntry)this.dictionary.get(feature);
        if (index == null) {
            index = new HEntry(this.dictionary.size(), this.stateNum);
            this.dictionary.put(feature, index);
        }
        index.addFrequency(label, 1);
        return index.getIndex();
    }

    @Override
    public void finalize() {
        this.cntsOverAllFeature = new int[this.stateNum];
        this.cntsArray = new int[this.dictionary.size()][];
        this.cntsOverAllState = new int[this.dictionary.size()];
        Enumeration e = this.dictionary.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            HEntry entry = (HEntry)this.dictionary.get(key);
            this.cntsArray[((HEntry)entry).index] = entry.stateArray;
            this.cntsOverAllState[((HEntry)entry).index] = MathUtil.sumArray(entry.stateArray);
        }
        for (int i = 0; i < this.stateNum; ++i) {
            this.cntsOverAllFeature[i] = 0;
            for (int m = 0; m < this.cntsArray.length; ++m) {
                int n = i;
                this.cntsOverAllFeature[n] = this.cntsOverAllFeature[n] + this.cntsArray[m][i];
            }
            this.allTotal += this.cntsOverAllFeature[i];
        }
        this.finalized = true;
    }

    @Override
    public boolean read(String filename) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(new File(filename)));
            int dictLen = Integer.parseInt(in.readLine());
            this.cntsOverAllFeature = new int[this.stateNum];
            this.cntsArray = new int[dictLen][this.stateNum];
            this.cntsOverAllState = new int[dictLen];
            for (int l = 0; l < dictLen && (line = in.readLine()) != null; ++l) {
                StringTokenizer entry = new StringTokenizer(line, " ");
                Integer key = Integer.getInteger(entry.nextToken());
                int pos = Integer.parseInt(entry.nextToken());
                HEntry hEntry = new HEntry(pos);
                this.dictionary.put(key, hEntry);
                while (entry.hasMoreTokens()) {
                    int cnt;
                    StringTokenizer scp = new StringTokenizer(entry.nextToken(), ":");
                    int state = Integer.parseInt(scp.nextToken());
                    this.cntsArray[pos][state] = cnt = Integer.parseInt(scp.nextToken());
                }
                this.cntsOverAllState[pos] = MathUtil.sumArray(this.cntsArray[pos]);
            }
            for (int i = 0; i < this.stateNum; ++i) {
                this.cntsOverAllFeature[i] = 0;
                for (int m = 0; m < this.cntsArray.length; ++m) {
                    int n = i;
                    this.cntsOverAllFeature[n] = this.cntsOverAllFeature[n] + this.cntsArray[m][i];
                }
                this.allTotal += this.cntsOverAllFeature[i];
            }
            this.finalized = true;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean write(String filename) {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(new File(filename)));
            out.println(this.dictionary.size());
            Enumeration element = this.dictionary.keys();
            while (element.hasMoreElements()) {
                Integer key = (Integer)element.nextElement();
                int pos = this.getIndex(key);
                out.print(key.toString() + " " + pos);
                int s = this.getNextStateWithFeature(pos, -1);
                while (s != -1) {
                    out.print(" " + s + ":" + this.cntsArray[pos][s]);
                    s = this.getNextStateWithFeature(pos, s);
                }
                out.println("");
            }
            out.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private class HEntry {
        private int index;
        private int[] stateArray;

        public HEntry(int v) {
            this.index = v;
            this.stateArray = null;
        }

        public HEntry(int v, int numStates) {
            this.index = v;
            this.stateArray = new int[numStates];
        }

        public void addFrequency(int state, int inc) {
            int n = state;
            this.stateArray[n] = this.stateArray[n] + inc;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

