/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.feature;

import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureIdentifier;

public class BasicFeature
implements Feature {
    private FeatureIdentifier id;
    private int index;
    private int ystart;
    private int yend;
    private double val;

    public BasicFeature() {
        this.index = -1;
        this.ystart = -1;
        this.yend = -1;
        this.id = null;
    }

    public BasicFeature(String id, int label, double val) {
        this(id, -1, label, val);
    }

    public BasicFeature(FeatureIdentifier id, int label, double val) {
        this(id, -1, label, val);
    }

    public BasicFeature(String id, int prevLabel, int label, double val) {
        this(new FeatureIdentifier(id), prevLabel, label, val);
    }

    public BasicFeature(FeatureIdentifier id, int prevLabel, int label, double val) {
        this.id = id;
        this.yend = label;
        this.val = val;
        this.ystart = prevLabel;
        this.index = -1;
    }

    public BasicFeature(BasicFeature f) {
        this.copyFrom(f);
    }

    public void copyFrom(BasicFeature f) {
        this.index = f.getIndex();
        this.ystart = f.getPrevLabel();
        this.yend = f.getLabel();
        this.val = f.getValue();
        this.id = f.getID().copy();
    }

    @Override
    public Feature copy() {
        return new BasicFeature(this);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getLabel() {
        return this.yend;
    }

    @Override
    public void setLabel(int label) {
        this.yend = label;
    }

    @Override
    public int getPrevLabel() {
        return this.ystart;
    }

    @Override
    public void setPrevLabel(int prevLabel) {
        this.ystart = prevLabel;
    }

    @Override
    public double getValue() {
        return this.val;
    }

    @Override
    public void setValue(double val) {
        this.val = val;
    }

    public String toString() {
        return this.id + " " + this.val;
    }

    @Override
    public FeatureIdentifier getID() {
        return this.id;
    }

    @Override
    public void setID(FeatureIdentifier id) {
        this.id = id;
    }
}

