/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.data;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.data.DataWriter;
import dragon.ml.seqmodel.data.Dataset;
import dragon.ml.seqmodel.data.LabelConverter;
import dragon.util.FileUtil;
import java.io.PrintWriter;

public class FlatSegmentWriter
implements DataWriter {
    private PrintWriter out;
    private LabelConverter labelConverter;
    private String tagDelimit;

    public FlatSegmentWriter(String outFile, LabelConverter labelConverter) {
        this.labelConverter = labelConverter;
        this.out = FileUtil.getPrintWriter(outFile);
        this.tagDelimit = "|";
    }

    @Override
    public boolean write(Dataset dataset) {
        dataset.startScan();
        while (dataset.hasNext()) {
            this.write(dataset.next());
        }
        return true;
    }

    @Override
    public boolean write(DataSequence dataSeq) {
        try {
            int segStart = 0;
            while (segStart < dataSeq.length()) {
                int segEnd = dataSeq.getSegmentEnd(segStart);
                StringBuffer segment = new StringBuffer(dataSeq.getToken(segStart).getContent());
                for (int i = segStart + 1; i <= segEnd; ++i) {
                    segment.append(" " + dataSeq.getToken(i).getContent());
                }
                segment.append(this.tagDelimit);
                segment.append(this.labelConverter.getExternalLabelString(dataSeq.getOriginalLabel(segStart)));
                this.out.println(segment.toString());
                segStart = segEnd + 1;
            }
            this.out.println();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void close() {
        this.out.close();
    }
}

