/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.data;

import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.data.Dataset;
import java.util.Vector;

public class BasicDataset
implements Dataset {
    private Vector vector = new Vector();
    private int originalLabelNum;
    private int labelNum;
    private int markovOrder;
    private int curPos;

    public BasicDataset(int originalLabelNum, int markovOrder) {
        this.originalLabelNum = originalLabelNum;
        this.markovOrder = markovOrder;
        this.labelNum = 1;
        for (int i = 0; i < markovOrder; ++i) {
            this.labelNum *= originalLabelNum;
        }
    }

    public Dataset copy() {
        BasicDataset dataset = new BasicDataset(this.originalLabelNum, this.markovOrder);
        this.startScan();
        while (this.hasNext()) {
            dataset.add(this.next().copy());
        }
        return dataset;
    }

    @Override
    public int size() {
        return this.vector.size();
    }

    @Override
    public void startScan() {
        this.curPos = 0;
    }

    @Override
    public boolean hasNext() {
        return this.curPos < this.vector.size();
    }

    @Override
    public DataSequence next() {
        ++this.curPos;
        return (DataSequence)this.vector.get(this.curPos - 1);
    }

    public boolean add(DataSequence seq) {
        seq.setParent(this);
        this.vector.add(seq);
        return true;
    }

    @Override
    public int getLabelNum() {
        return this.labelNum;
    }

    @Override
    public int getOriginalLabelNum() {
        return this.originalLabelNum;
    }

    @Override
    public int getMarkovOrder() {
        return this.markovOrder;
    }
}

