/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.data;

import dragon.ml.seqmodel.data.BasicToken;
import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.data.Dataset;
import java.util.Vector;

public class BasicDataSequence
implements DataSequence {
    private Vector vector;
    private Dataset parent = null;

    public BasicDataSequence() {
        this(50);
    }

    public BasicDataSequence(int length) {
        this.vector = new Vector(length, 50);
    }

    @Override
    public DataSequence copy() {
        int len = this.length();
        BasicDataSequence seq = new BasicDataSequence(this.length());
        for (int i = 0; i < len; ++i) {
            seq.add(this.getToken(i).copy());
        }
        return seq;
    }

    @Override
    public Dataset getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Dataset parent) {
        this.parent = parent;
    }

    @Override
    public int length() {
        return this.vector.size();
    }

    @Override
    public int getLabel(int pos) {
        int markovOrder = this.parent.getMarkovOrder();
        if (markovOrder <= 1) {
            BasicToken token = (BasicToken)this.vector.get(pos);
            return token.getLabel();
        }
        if (pos >= markovOrder - 1) {
            int label = 0;
            for (int i = pos + 1 - markovOrder; i <= pos; ++i) {
                BasicToken token = (BasicToken)this.vector.get(i);
                label = label * this.parent.getOriginalLabelNum() + token.getLabel();
            }
            return label;
        }
        return -1;
    }

    @Override
    public int getOriginalLabel(int pos) {
        return ((BasicToken)this.vector.get(pos)).getLabel();
    }

    @Override
    public BasicToken getToken(int pos) {
        return (BasicToken)this.vector.get(pos);
    }

    @Override
    public void setLabel(int pos, int label) {
        BasicToken token = (BasicToken)this.vector.get(pos);
        int markovOrder = this.parent.getMarkovOrder();
        if (markovOrder > 1) {
            token.setLabel(label % this.parent.getOriginalLabelNum());
            if (pos == markovOrder - 1) {
                label /= this.parent.getOriginalLabelNum();
                while (pos > 0) {
                    token = (BasicToken)this.vector.get(--pos);
                    token.setLabel((label /= this.parent.getOriginalLabelNum()) % this.parent.getOriginalLabelNum());
                }
            }
        } else {
            token.setLabel(label);
        }
    }

    public void add(BasicToken token) {
        this.vector.add(token);
    }

    @Override
    public int getSegmentEnd(int segmentStart) {
        int curPos;
        int len = this.length();
        for (curPos = segmentStart + 1; curPos < len && !this.getToken(curPos).isSegmentStart(); ++curPos) {
        }
        return curPos - 1;
    }

    @Override
    public void setSegment(int segmentStart, int segmentEnd, int label) {
        if (this.parent.getMarkovOrder() > 1) {
            System.out.println("Only first-order markov allowed for segment sequencing!");
            return;
        }
        BasicToken curToken = this.getToken(segmentStart);
        curToken.setSegmentMarker(true);
        curToken.setLabel(label);
        for (int i = segmentStart + 1; i <= segmentEnd; ++i) {
            curToken = this.getToken(i);
            curToken.setSegmentMarker(false);
            curToken.setLabel(label);
        }
        if (segmentEnd < this.length() - 1) {
            this.getToken(segmentEnd + 1).setSegmentMarker(true);
        }
    }
}

