/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.crf;

import dragon.matrix.DoubleFlatDenseMatrix;
import dragon.ml.seqmodel.crf.AbstractCRF;
import dragon.ml.seqmodel.crf.Labeler;
import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.FeatureGenerator;
import dragon.ml.seqmodel.model.ModelGraph;
import dragon.util.MathUtil;

public class ViterbiSegmentLabeler
extends AbstractCRF
implements Labeler {
    private int maxLen;
    private int[][] winningLabel;
    private int[][] winningPos;
    private double[] score;
    private int[] solutionOrder;

    public ViterbiSegmentLabeler(ModelGraph model, FeatureGenerator featureGenerator, int maxSegmentLength) {
        super(model, featureGenerator);
        this.maxLen = maxSegmentLength;
        this.score = new double[model.getStateNum()];
    }

    @Override
    public boolean label(DataSequence dataSeq) {
        return this.label(dataSeq, this.lambda);
    }

    @Override
    public boolean label(DataSequence dataSeq, double[] lambda) {
        int i;
        int stateNum = this.model.getStateNum();
        DoubleFlatDenseMatrix transMatrix = new DoubleFlatDenseMatrix(stateNum, stateNum);
        DoubleFlatDenseMatrix[] scoreMatrix = new DoubleFlatDenseMatrix[this.maxLen];
        for (i = 0; i < this.maxLen; ++i) {
            scoreMatrix[i] = new DoubleFlatDenseMatrix(stateNum, stateNum);
        }
        double[][] partialScore = new double[dataSeq.length()][stateNum];
        this.winningLabel = new int[dataSeq.length()][stateNum];
        this.winningPos = new int[dataSeq.length()][stateNum];
        for (i = 0; i < dataSeq.length(); ++i) {
            int yp;
            int yi;
            int ell;
            if (i > 0) {
                for (ell = 0; ell < this.maxLen && i - ell > 0; ++ell) {
                    this.computeTransMatrix(lambda, dataSeq, i - ell, i, transMatrix, false);
                    scoreMatrix[ell].assign(0.0);
                    for (yi = 0; yi < stateNum; ++yi) {
                        for (yp = 0; yp < stateNum; ++yp) {
                            scoreMatrix[ell].setDouble(yp, yi, partialScore[i - ell - 1][yp] + transMatrix.getDouble(yp, yi));
                        }
                    }
                }
            } else {
                for (yi = 0; yi < stateNum; ++yi) {
                    partialScore[i][yi] = transMatrix.getDouble(0, yi);
                    this.winningPos[i][yi] = 0;
                }
            }
            if (i <= 0) continue;
            for (yi = 0; yi < stateNum; ++yi) {
                int prevLabel = -1;
                int startPos = -1;
                double maxScore = -1.0;
                for (ell = 0; ell < this.maxLen && i - ell >= 0; ++ell) {
                    for (yp = 0; yp < stateNum; ++yp) {
                        if (!(scoreMatrix[ell].getDouble(yp, yi) > maxScore)) continue;
                        maxScore = scoreMatrix[ell].getDouble(yp, yi);
                        prevLabel = yp;
                        startPos = i - ell;
                    }
                }
                partialScore[i][yi] = maxScore;
                this.winningLabel[i][yi] = prevLabel;
                this.winningPos[i][yi] = startPos;
            }
        }
        MathUtil.copyArray(partialScore[dataSeq.length() - 1], this.score);
        this.solutionOrder = MathUtil.rankElementInArray(this.score, true);
        this.getBestSolution(dataSeq, 0);
        return true;
    }

    @Override
    public double getBestSolution(DataSequence dataSeq, int order) {
        int endPos = dataSeq.length() - 1;
        int prevLabel = this.solutionOrder[order];
        int startPos = this.winningPos[endPos][prevLabel];
        while (startPos >= 0) {
            dataSeq.setSegment(startPos, endPos, prevLabel);
            prevLabel = this.winningLabel[endPos][prevLabel];
            endPos = startPos - 1;
            if (endPos < 0) break;
            startPos = this.winningPos[endPos][prevLabel];
        }
        this.model.mapStateToLabel(dataSeq);
        return this.score[this.solutionOrder[order]];
    }
}

