/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.crf;

import dragon.matrix.DoubleFlatDenseMatrix;
import dragon.ml.seqmodel.crf.AbstractCRF;
import dragon.ml.seqmodel.crf.Labeler;
import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.FeatureGenerator;
import dragon.ml.seqmodel.model.ModelGraph;
import dragon.util.MathUtil;

public class ViterbiBasicLabeler
extends AbstractCRF
implements Labeler {
    private int[][] winningLabel;
    private double[] score;
    private int[] solutionOrder;

    public ViterbiBasicLabeler(ModelGraph model, FeatureGenerator featureGenerator) {
        super(model, featureGenerator);
        this.score = new double[model.getStateNum()];
    }

    @Override
    public boolean label(DataSequence dataSeq) {
        return this.label(dataSeq, this.lambda);
    }

    @Override
    public boolean label(DataSequence dataSeq, double[] lambda) {
        int stateNum = this.model.getStateNum();
        int markovOrder = this.model.getMarkovOrder();
        DoubleFlatDenseMatrix transMatrix = new DoubleFlatDenseMatrix(stateNum, stateNum);
        DoubleFlatDenseMatrix scoreMatrix = new DoubleFlatDenseMatrix(stateNum, stateNum);
        double[] arrPrevScore = new double[stateNum];
        this.winningLabel = new int[dataSeq.length()][stateNum];
        for (int i = markovOrder - 1; i < dataSeq.length(); ++i) {
            int yp;
            this.computeTransMatrix(lambda, dataSeq, i, i, transMatrix, false);
            scoreMatrix.assign(0.0);
            int yi = this.edgeGen.firstLabel(i);
            while (yi < stateNum) {
                if (i > markovOrder - 1) {
                    yp = this.edgeGen.first(yi);
                    while (yp < stateNum) {
                        scoreMatrix.setDouble(yp, yi, arrPrevScore[yp] + transMatrix.getDouble(yp, yi));
                        yp = this.edgeGen.next(yi, yp);
                    }
                } else {
                    arrPrevScore[yi] = transMatrix.getDouble(0, yi);
                }
                yi = this.edgeGen.nextLabel(yi, i);
            }
            if (i <= markovOrder - 1) continue;
            for (yi = 0; yi < stateNum; ++yi) {
                int prevLabel = 0;
                double maxScore = scoreMatrix.getDouble(prevLabel, yi);
                for (yp = 1; yp < stateNum; ++yp) {
                    if (!(scoreMatrix.getDouble(yp, yi) > maxScore)) continue;
                    maxScore = scoreMatrix.getDouble(yp, yi);
                    prevLabel = yp;
                }
                arrPrevScore[yi] = maxScore;
                this.winningLabel[i][yi] = prevLabel;
            }
        }
        MathUtil.copyArray(arrPrevScore, this.score);
        this.solutionOrder = MathUtil.rankElementInArray(this.score, true);
        this.getBestSolution(dataSeq, 0);
        return true;
    }

    @Override
    public double getBestSolution(DataSequence dataSeq, int order) {
        int markovOrder = this.model.getMarkovOrder();
        int prevLabel = this.solutionOrder[order];
        for (int i = dataSeq.length() - 1; i >= markovOrder - 1; --i) {
            dataSeq.setLabel(i, prevLabel);
            prevLabel = this.winningLabel[i][prevLabel];
        }
        this.model.mapStateToLabel(dataSeq);
        return this.score[this.solutionOrder[order]];
    }
}

