/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.crf;

import dragon.ml.seqmodel.crf.LBFGS;

public class Mcsrch {
    private static int[] infoc = new int[1];
    private static int j = 0;
    private static double dg = 0.0;
    private static double dgm = 0.0;
    private static double dginit = 0.0;
    private static double dgtest = 0.0;
    private static double[] dgx = new double[1];
    private static double[] dgxm = new double[1];
    private static double[] dgy = new double[1];
    private static double[] dgym = new double[1];
    private static double finit = 0.0;
    private static double ftest1 = 0.0;
    private static double fm = 0.0;
    private static double[] fx = new double[1];
    private static double[] fxm = new double[1];
    private static double[] fy = new double[1];
    private static double[] fym = new double[1];
    private static double p5 = 0.0;
    private static double p66 = 0.0;
    private static double[] stx = new double[1];
    private static double[] sty = new double[1];
    private static double stmin = 0.0;
    private static double stmax = 0.0;
    private static double width = 0.0;
    private static double width1 = 0.0;
    private static double xtrapf = 0.0;
    private static boolean[] brackt = new boolean[1];
    private static boolean stage1 = false;

    static double sqr(double x) {
        return x * x;
    }

    static double max3(double x, double y, double z) {
        return x < y ? (y < z ? z : y) : (x < z ? z : x);
    }

    public static void mcsrch(int n, double[] x, double f, double[] g, double[] s, int is0, double[] stp, double ftol, double xtol, int maxfev, int[] info, int[] nfev, double[] wa) {
        p5 = 0.5;
        p66 = 0.66;
        xtrapf = 4.0;
        if (info[0] != -1) {
            Mcsrch.infoc[0] = 1;
            if (n <= 0 || stp[0] <= 0.0 || ftol < 0.0 || LBFGS.gtol < 0.0 || xtol < 0.0 || LBFGS.stpmin < 0.0 || LBFGS.stpmax < LBFGS.stpmin || maxfev <= 0) {
                return;
            }
            dginit = 0.0;
            for (j = 1; j <= n; ++j) {
                dginit += g[j - 1] * s[is0 + j - 1];
            }
            if (dginit >= 0.0) {
                System.out.println("The search direction is not a descent direction.");
                return;
            }
            Mcsrch.brackt[0] = false;
            stage1 = true;
            nfev[0] = 0;
            finit = f;
            dgtest = ftol * dginit;
            width = LBFGS.stpmax - LBFGS.stpmin;
            width1 = width / p5;
            for (j = 1; j <= n; ++j) {
                wa[Mcsrch.j - 1] = x[j - 1];
            }
            Mcsrch.stx[0] = 0.0;
            Mcsrch.fx[0] = finit;
            Mcsrch.dgx[0] = dginit;
            Mcsrch.sty[0] = 0.0;
            Mcsrch.fy[0] = finit;
            Mcsrch.dgy[0] = dginit;
        }
        while (true) {
            if (info[0] != -1) {
                if (brackt[0]) {
                    stmin = Math.min(stx[0], sty[0]);
                    stmax = Math.max(stx[0], sty[0]);
                } else {
                    stmin = stx[0];
                    stmax = stp[0] + xtrapf * (stp[0] - stx[0]);
                }
                stp[0] = Math.max(stp[0], LBFGS.stpmin);
                stp[0] = Math.min(stp[0], LBFGS.stpmax);
                if (brackt[0] && (stp[0] <= stmin || stp[0] >= stmax) || nfev[0] >= maxfev - 1 || infoc[0] == 0 || brackt[0] && stmax - stmin <= xtol * stmax) {
                    stp[0] = stx[0];
                }
                for (j = 1; j <= n; ++j) {
                    x[Mcsrch.j - 1] = wa[j - 1] + stp[0] * s[is0 + j - 1];
                }
                info[0] = -1;
                return;
            }
            info[0] = 0;
            nfev[0] = nfev[0] + 1;
            dg = 0.0;
            for (j = 1; j <= n; ++j) {
                dg += g[j - 1] * s[is0 + j - 1];
            }
            ftest1 = finit + stp[0] * dgtest;
            if (brackt[0] && (stp[0] <= stmin || stp[0] >= stmax) || infoc[0] == 0) {
                info[0] = 6;
            }
            if (stp[0] == LBFGS.stpmax && f <= ftest1 && dg <= dgtest) {
                info[0] = 5;
            }
            if (stp[0] == LBFGS.stpmin && (f > ftest1 || dg >= dgtest)) {
                info[0] = 4;
            }
            if (nfev[0] >= maxfev) {
                info[0] = 3;
            }
            if (brackt[0] && stmax - stmin <= xtol * stmax) {
                info[0] = 2;
            }
            if (f <= ftest1 && Math.abs(dg) <= LBFGS.gtol * -dginit) {
                info[0] = 1;
            }
            if (info[0] != 0) {
                return;
            }
            if (stage1 && f <= ftest1 && dg >= Math.min(ftol, LBFGS.gtol) * dginit) {
                stage1 = false;
            }
            if (stage1 && f <= fx[0] && f > ftest1) {
                fm = f - stp[0] * dgtest;
                Mcsrch.fxm[0] = fx[0] - stx[0] * dgtest;
                Mcsrch.fym[0] = fy[0] - sty[0] * dgtest;
                dgm = dg - dgtest;
                Mcsrch.dgxm[0] = dgx[0] - dgtest;
                Mcsrch.dgym[0] = dgy[0] - dgtest;
                Mcsrch.mcstep(stx, fxm, dgxm, sty, fym, dgym, stp, fm, dgm, brackt, stmin, stmax, infoc);
                Mcsrch.fx[0] = fxm[0] + stx[0] * dgtest;
                Mcsrch.fy[0] = fym[0] + sty[0] * dgtest;
                Mcsrch.dgx[0] = dgxm[0] + dgtest;
                Mcsrch.dgy[0] = dgym[0] + dgtest;
            } else {
                Mcsrch.mcstep(stx, fx, dgx, sty, fy, dgy, stp, f, dg, brackt, stmin, stmax, infoc);
            }
            if (!brackt[0]) continue;
            if (Math.abs(sty[0] - stx[0]) >= p66 * width1) {
                stp[0] = stx[0] + p5 * (sty[0] - stx[0]);
            }
            width1 = width;
            width = Math.abs(sty[0] - stx[0]);
        }
    }

    public static void mcstep(double[] stx, double[] fx, double[] dx, double[] sty, double[] fy, double[] dy, double[] stp, double fp, double dp, boolean[] brackt, double stpmin, double stpmax, int[] info) {
        double stpf;
        boolean bound;
        info[0] = 0;
        if (brackt[0] && (stp[0] <= Math.min(stx[0], sty[0]) || stp[0] >= Math.max(stx[0], sty[0])) || dx[0] * (stp[0] - stx[0]) >= 0.0 || stpmax < stpmin) {
            return;
        }
        double sgnd = dp * (dx[0] / Math.abs(dx[0]));
        if (fp > fx[0]) {
            info[0] = 1;
            bound = true;
            double theta = 3.0 * (fx[0] - fp) / (stp[0] - stx[0]) + dx[0] + dp;
            double s = Mcsrch.max3(Math.abs(theta), Math.abs(dx[0]), Math.abs(dp));
            double gamma = s * Math.sqrt(Mcsrch.sqr(theta / s) - dx[0] / s * (dp / s));
            if (stp[0] < stx[0]) {
                gamma = -gamma;
            }
            double p = gamma - dx[0] + theta;
            double q = gamma - dx[0] + gamma + dp;
            double r = p / q;
            double stpc = stx[0] + r * (stp[0] - stx[0]);
            double stpq = stx[0] + dx[0] / ((fx[0] - fp) / (stp[0] - stx[0]) + dx[0]) / 2.0 * (stp[0] - stx[0]);
            stpf = Math.abs(stpc - stx[0]) < Math.abs(stpq - stx[0]) ? stpc : stpc + (stpq - stpc) / 2.0;
            brackt[0] = true;
        } else if (sgnd < 0.0) {
            info[0] = 2;
            bound = false;
            double theta = 3.0 * (fx[0] - fp) / (stp[0] - stx[0]) + dx[0] + dp;
            double s = Mcsrch.max3(Math.abs(theta), Math.abs(dx[0]), Math.abs(dp));
            double gamma = s * Math.sqrt(Mcsrch.sqr(theta / s) - dx[0] / s * (dp / s));
            if (stp[0] > stx[0]) {
                gamma = -gamma;
            }
            double p = gamma - dp + theta;
            double q = gamma - dp + gamma + dx[0];
            double r = p / q;
            double stpc = stp[0] + r * (stx[0] - stp[0]);
            double stpq = stp[0] + dp / (dp - dx[0]) * (stx[0] - stp[0]);
            stpf = Math.abs(stpc - stp[0]) > Math.abs(stpq - stp[0]) ? stpc : stpq;
            brackt[0] = true;
        } else if (Math.abs(dp) < Math.abs(dx[0])) {
            double q;
            double p;
            double r;
            info[0] = 3;
            bound = true;
            double theta = 3.0 * (fx[0] - fp) / (stp[0] - stx[0]) + dx[0] + dp;
            double s = Mcsrch.max3(Math.abs(theta), Math.abs(dx[0]), Math.abs(dp));
            double gamma = s * Math.sqrt(Math.max(0.0, Mcsrch.sqr(theta / s) - dx[0] / s * (dp / s)));
            if (stp[0] > stx[0]) {
                gamma = -gamma;
            }
            double stpc = (r = (p = gamma - dp + theta) / (q = gamma + (dx[0] - dp) + gamma)) < 0.0 && gamma != 0.0 ? stp[0] + r * (stx[0] - stp[0]) : (stp[0] > stx[0] ? stpmax : stpmin);
            double stpq = stp[0] + dp / (dp - dx[0]) * (stx[0] - stp[0]);
            stpf = brackt[0] ? (Math.abs(stp[0] - stpc) < Math.abs(stp[0] - stpq) ? stpc : stpq) : (Math.abs(stp[0] - stpc) > Math.abs(stp[0] - stpq) ? stpc : stpq);
        } else {
            info[0] = 4;
            bound = false;
            if (brackt[0]) {
                double stpc;
                double theta = 3.0 * (fp - fy[0]) / (sty[0] - stp[0]) + dy[0] + dp;
                double s = Mcsrch.max3(Math.abs(theta), Math.abs(dy[0]), Math.abs(dp));
                double gamma = s * Math.sqrt(Mcsrch.sqr(theta / s) - dy[0] / s * (dp / s));
                if (stp[0] > sty[0]) {
                    gamma = -gamma;
                }
                double p = gamma - dp + theta;
                double q = gamma - dp + gamma + dy[0];
                double r = p / q;
                stpf = stpc = stp[0] + r * (sty[0] - stp[0]);
            } else {
                stpf = stp[0] > stx[0] ? stpmax : stpmin;
            }
        }
        if (fp > fx[0]) {
            sty[0] = stp[0];
            fy[0] = fp;
            dy[0] = dp;
        } else {
            if (sgnd < 0.0) {
                sty[0] = stx[0];
                fy[0] = fx[0];
                dy[0] = dx[0];
            }
            stx[0] = stp[0];
            fx[0] = fp;
            dx[0] = dp;
        }
        stpf = Math.min(stpmax, stpf);
        stp[0] = stpf = Math.max(stpmin, stpf);
        if (brackt[0] && bound) {
            stp[0] = sty[0] > stx[0] ? Math.min(stx[0] + 0.66 * (sty[0] - stx[0]), stp[0]) : Math.max(stx[0] + 0.66 * (sty[0] - stx[0]), stp[0]);
        }
    }
}

