/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.crf;

import dragon.ml.seqmodel.crf.Mcsrch;

public class LBFGS {
    public static double gtol = 0.9;
    public static double stpmin = 1.0E-20;
    public static double stpmax = 1.0E20;
    public static double[] solution_cache = null;
    private static double gnorm = 0.0;
    private static double stp1 = 0.0;
    private static double ftol = 0.0;
    private static double[] stp = new double[1];
    private static double ys = 0.0;
    private static double yy = 0.0;
    private static double sq = 0.0;
    private static double yr = 0.0;
    private static double beta = 0.0;
    private static double xnorm = 0.0;
    private static int iter = 0;
    private static int nfun = 0;
    private static int point = 0;
    private static int ispt = 0;
    private static int iypt = 0;
    private static int maxfev = 0;
    private static int[] info = new int[1];
    private static int bound = 0;
    private static int npt = 0;
    private static int cp = 0;
    private static int i = 0;
    private static int[] nfev = new int[1];
    private static int inmc = 0;
    private static int iycn = 0;
    private static int iscn = 0;
    private static boolean finish = false;
    private static double[] w = null;

    public static int nfevaluations() {
        return nfun;
    }

    public static void lbfgs(int n, int m, double[] x, double f, double[] g, boolean diagco, double[] diag, int[] iprint, double eps, double xtol, int[] iflag) throws ExceptionWithIflag {
        boolean execute_entire_while_loop = false;
        if (w == null || w.length != n * (2 * m + 1) + 2 * m) {
            w = new double[n * (2 * m + 1) + 2 * m];
        }
        if (iflag[0] == 0) {
            solution_cache = new double[n];
            System.arraycopy(x, 0, solution_cache, 0, n);
            iter = 0;
            if (n <= 0 || m <= 0) {
                iflag[0] = -3;
                throw new ExceptionWithIflag(iflag[0], "Improper input parameters  (n or m are not positive.)");
            }
            if (gtol <= 1.0E-4) {
                System.err.println("LBFGS.lbfgs: gtol is less than or equal to 0.0001. It has been reset to 0.9.");
                gtol = 0.9;
            }
            nfun = 1;
            point = 0;
            finish = false;
            if (diagco) {
                for (i = 1; i <= n; ++i) {
                    if (!(diag[i - 1] <= 0.0)) continue;
                    iflag[0] = -2;
                    throw new ExceptionWithIflag(iflag[0], "The " + i + "-th diagonal element of the inverse hessian approximation is not positive.");
                }
            } else {
                for (i = 1; i <= n; ++i) {
                    diag[LBFGS.i - 1] = 1.0;
                }
            }
            ispt = n + 2 * m;
            iypt = ispt + n * m;
            for (i = 1; i <= n; ++i) {
                LBFGS.w[LBFGS.ispt + LBFGS.i - 1] = -g[i - 1] * diag[i - 1];
            }
            gnorm = Math.sqrt(LBFGS.ddot(n, g, 0, 1, g, 0, 1));
            stp1 = 1.0 / gnorm;
            ftol = 1.0E-4;
            maxfev = 20;
            if (iprint[0] >= 0) {
                LBFGS.lb1(iprint, iter, nfun, gnorm, n, m, x, f, g, stp, finish);
            }
            execute_entire_while_loop = true;
        }
        while (true) {
            if (execute_entire_while_loop) {
                LBFGS.info[0] = 0;
                bound = ++iter - 1;
                if (iter != 1) {
                    if (iter > m) {
                        bound = m;
                    }
                    ys = LBFGS.ddot(n, w, iypt + npt, 1, w, ispt + npt, 1);
                    if (!diagco) {
                        yy = LBFGS.ddot(n, w, iypt + npt, 1, w, iypt + npt, 1);
                        for (i = 1; i <= n; ++i) {
                            diag[LBFGS.i - 1] = ys / yy;
                        }
                    } else {
                        iflag[0] = 2;
                        return;
                    }
                }
            }
            if (execute_entire_while_loop || iflag[0] == 2) {
                if (iter != 1) {
                    if (diagco) {
                        for (i = 1; i <= n; ++i) {
                            if (!(diag[i - 1] <= 0.0)) continue;
                            iflag[0] = -2;
                            throw new ExceptionWithIflag(iflag[0], "The " + i + "-th diagonal element of the inverse hessian approximation is not positive.");
                        }
                    }
                    cp = point;
                    if (point == 0) {
                        cp = m;
                    }
                    LBFGS.w[n + LBFGS.cp - 1] = 1.0 / ys;
                    for (i = 1; i <= n; ++i) {
                        LBFGS.w[LBFGS.i - 1] = -g[i - 1];
                    }
                    cp = point;
                    for (i = 1; i <= bound; ++i) {
                        if (--cp == -1) {
                            cp = m - 1;
                        }
                        sq = LBFGS.ddot(n, w, ispt + cp * n, 1, w, 0, 1);
                        inmc = n + m + cp + 1;
                        iycn = iypt + cp * n;
                        LBFGS.w[LBFGS.inmc - 1] = w[n + cp + 1 - 1] * sq;
                        LBFGS.daxpy(n, -w[inmc - 1], w, iycn, 1, w, 0, 1);
                    }
                    for (i = 1; i <= n; ++i) {
                        LBFGS.w[LBFGS.i - 1] = diag[i - 1] * w[i - 1];
                    }
                    for (i = 1; i <= bound; ++i) {
                        yr = LBFGS.ddot(n, w, iypt + cp * n, 1, w, 0, 1);
                        beta = w[n + cp + 1 - 1] * yr;
                        inmc = n + m + cp + 1;
                        beta = w[inmc - 1] - beta;
                        iscn = ispt + cp * n;
                        LBFGS.daxpy(n, beta, w, iscn, 1, w, 0, 1);
                        if (++cp != m) continue;
                        cp = 0;
                    }
                    for (i = 1; i <= n; ++i) {
                        LBFGS.w[LBFGS.ispt + LBFGS.point * n + LBFGS.i - 1] = w[i - 1];
                    }
                }
                LBFGS.nfev[0] = 0;
                LBFGS.stp[0] = 1.0;
                if (iter == 1) {
                    LBFGS.stp[0] = stp1;
                }
                for (i = 1; i <= n; ++i) {
                    LBFGS.w[LBFGS.i - 1] = g[i - 1];
                }
            }
            Mcsrch.mcsrch(n, x, f, g, w, ispt + point * n, stp, ftol, xtol, maxfev, info, nfev, diag);
            if (info[0] == -1) {
                iflag[0] = 1;
                return;
            }
            if (info[0] != 1) {
                iflag[0] = -1;
                throw new ExceptionWithIflag(iflag[0], "Line search failed. See documentation of routine mcsrch. Error return of line search: info = " + info[0] + " Possible causes: function or gradient are incorrect, or incorrect tolerances.");
            }
            nfun += nfev[0];
            npt = point * n;
            for (i = 1; i <= n; ++i) {
                LBFGS.w[LBFGS.ispt + LBFGS.npt + LBFGS.i - 1] = stp[0] * w[ispt + npt + i - 1];
                LBFGS.w[LBFGS.iypt + LBFGS.npt + LBFGS.i - 1] = g[i - 1] - w[i - 1];
            }
            if (++point == m) {
                point = 0;
            }
            gnorm = Math.sqrt(LBFGS.ddot(n, g, 0, 1, g, 0, 1));
            xnorm = Math.sqrt(LBFGS.ddot(n, x, 0, 1, x, 0, 1));
            if (gnorm / (xnorm = Math.max(1.0, xnorm)) <= eps) {
                finish = true;
            }
            if (iprint[0] >= 0) {
                LBFGS.lb1(iprint, iter, nfun, gnorm, n, m, x, f, g, stp, finish);
            }
            System.arraycopy(x, 0, solution_cache, 0, n);
            if (finish) {
                iflag[0] = 0;
                return;
            }
            execute_entire_while_loop = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void lb1(int[] iprint, int iter, int nfun, double gnorm, int n, int m, double[] x, double f, double[] g, double[] stp, boolean finish) {
        if (iter == 0) {
            System.err.println("*************************************************");
            System.err.println("  n = " + n + "   number of corrections = " + m + "\n       initial values");
            System.err.println(" f =  " + f + "   gnorm =  " + gnorm);
            if (iprint[1] >= 1) {
                int i;
                System.err.print(" vector x =");
                for (i = 1; i <= n; ++i) {
                    System.err.print("  " + x[i - 1]);
                }
                System.err.println("");
                System.err.print(" gradient vector g =");
                for (i = 1; i <= n; ++i) {
                    System.err.print("  " + g[i - 1]);
                }
                System.err.println("");
            }
            System.err.println("*************************************************");
            System.err.println("\ti\tnfn\tfunc\tgnorm\tsteplength");
            return;
        } else {
            if (iprint[0] == 0 && iter != 1 && !finish) {
                return;
            }
            if (iprint[0] != 0) {
                if ((iter - 1) % iprint[0] != 0 && !finish) return;
                if (iprint[1] > 1 && iter > 1) {
                    System.err.println("\ti\tnfn\tfunc\tgnorm\tsteplength");
                }
                System.err.println("\t" + iter + "\t" + nfun + "\t" + f + "\t" + gnorm + "\t" + stp[0]);
            } else {
                if (iprint[1] > 1 && finish) {
                    System.err.println("\ti\tnfn\tfunc\tgnorm\tsteplength");
                }
                System.err.println("\t" + iter + "\t" + nfun + "\t" + f + "\t" + gnorm + "\t" + stp[0]);
            }
            if (iprint[1] == 2 || iprint[1] == 3) {
                int i;
                if (finish) {
                    System.err.print(" final point x =");
                } else {
                    System.err.print(" vector x =  ");
                }
                for (i = 1; i <= n; ++i) {
                    System.err.print("  " + x[i - 1]);
                }
                System.err.println("");
                if (iprint[1] == 3) {
                    System.err.print(" gradient vector g =");
                    for (i = 1; i <= n; ++i) {
                        System.err.print("  " + g[i - 1]);
                    }
                    System.err.println("");
                }
            }
            if (!finish) return;
            System.err.println(" The minimization terminated without detecting errors. iflag = 0");
        }
    }

    public static void daxpy(int n, double da, double[] dx, int ix0, int incx, double[] dy, int iy0, int incy) {
        int mp1;
        int i;
        if (n <= 0) {
            return;
        }
        if (da == 0.0) {
            return;
        }
        if (incx != 1 || incy != 1) {
            int ix = 1;
            int iy = 1;
            if (incx < 0) {
                ix = (-n + 1) * incx + 1;
            }
            if (incy < 0) {
                iy = (-n + 1) * incy + 1;
            }
            for (int i2 = 1; i2 <= n; ++i2) {
                dy[iy0 + iy - 1] = dy[iy0 + iy - 1] + da * dx[ix0 + ix - 1];
                ix += incx;
                iy += incy;
            }
            return;
        }
        int m = n % 4;
        if (m != 0) {
            for (i = 1; i <= m; ++i) {
                dy[iy0 + i - 1] = dy[iy0 + i - 1] + da * dx[ix0 + i - 1];
            }
            if (n < 4) {
                return;
            }
        }
        for (i = mp1 = m + 1; i <= n; i += 4) {
            dy[iy0 + i - 1] = dy[iy0 + i - 1] + da * dx[ix0 + i - 1];
            dy[iy0 + i + 1 - 1] = dy[iy0 + i + 1 - 1] + da * dx[ix0 + i + 1 - 1];
            dy[iy0 + i + 2 - 1] = dy[iy0 + i + 2 - 1] + da * dx[ix0 + i + 2 - 1];
            dy[iy0 + i + 3 - 1] = dy[iy0 + i + 3 - 1] + da * dx[ix0 + i + 3 - 1];
        }
    }

    public static double ddot(int n, double[] dx, int ix0, int incx, double[] dy, int iy0, int incy) {
        int mp1;
        int i;
        double dtemp = 0.0;
        if (n <= 0) {
            return 0.0;
        }
        if (incx != 1 || incy != 1) {
            int ix = 1;
            int iy = 1;
            if (incx < 0) {
                ix = (-n + 1) * incx + 1;
            }
            if (incy < 0) {
                iy = (-n + 1) * incy + 1;
            }
            for (int i2 = 1; i2 <= n; ++i2) {
                dtemp += dx[ix0 + ix - 1] * dy[iy0 + iy - 1];
                ix += incx;
                iy += incy;
            }
            return dtemp;
        }
        int m = n % 5;
        if (m != 0) {
            for (i = 1; i <= m; ++i) {
                dtemp += dx[ix0 + i - 1] * dy[iy0 + i - 1];
            }
            if (n < 5) {
                return dtemp;
            }
        }
        for (i = mp1 = m + 1; i <= n; i += 5) {
            dtemp = dtemp + dx[ix0 + i - 1] * dy[iy0 + i - 1] + dx[ix0 + i + 1 - 1] * dy[iy0 + i + 1 - 1] + dx[ix0 + i + 2 - 1] * dy[iy0 + i + 2 - 1] + dx[ix0 + i + 3 - 1] * dy[iy0 + i + 3 - 1] + dx[ix0 + i + 4 - 1] * dy[iy0 + i + 4 - 1];
        }
        return dtemp;
    }

    public static class ExceptionWithIflag
    extends Exception {
        private static final long serialVersionUID = 1L;
        public int iflag;

        public ExceptionWithIflag(int i, String s) {
            super(s);
            this.iflag = i;
        }

        @Override
        public String toString() {
            return this.getMessage() + " (iflag == " + this.iflag + ")";
        }
    }
}

