/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.crf;

public class EdgeGenerator {
    private int offset = 1;
    private int numOrigY;
    private int markovOrder;

    public EdgeGenerator(int originalLabelNum) {
        this(1, originalLabelNum);
    }

    public EdgeGenerator(int markovOrder, int originalLabelNum) {
        for (int i = 0; i < markovOrder - 1; ++i) {
            this.offset *= originalLabelNum;
        }
        this.numOrigY = originalLabelNum;
        this.markovOrder = markovOrder;
    }

    public int first(int destY) {
        return destY / this.numOrigY;
    }

    public int next(int destY, int currentSrcY) {
        return currentSrcY + this.offset;
    }

    public int firstLabel(int pos) {
        return 0;
    }

    public int nextLabel(int currentLabel, int pos) {
        if (pos >= this.markovOrder - 1 || currentLabel < this.numOrigY - 1) {
            return currentLabel + 1;
        }
        if ((double)currentLabel >= Math.pow(this.numOrigY, pos + 1)) {
            return this.numOrigY * this.offset;
        }
        return currentLabel + 1;
    }
}

