/*
 * Decompiled with CFR 0.152.
 */
package dragon.ml.seqmodel.crf;

import dragon.matrix.DoubleDenseMatrix;
import dragon.ml.seqmodel.crf.EdgeGenerator;
import dragon.ml.seqmodel.data.DataSequence;
import dragon.ml.seqmodel.feature.Feature;
import dragon.ml.seqmodel.feature.FeatureGenerator;
import dragon.ml.seqmodel.model.ModelGraph;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintWriter;

public abstract class AbstractCRF {
    protected EdgeGenerator edgeGen;
    protected FeatureGenerator featureGenerator;
    protected ModelGraph model;
    protected double[] lambda;

    public AbstractCRF(ModelGraph model, FeatureGenerator featureGen) {
        this.model = model;
        this.edgeGen = new EdgeGenerator(model.getMarkovOrder(), model.getOriginalLabelNum());
        this.featureGenerator = featureGen;
    }

    public FeatureGenerator getFeatureGenerator() {
        return this.featureGenerator;
    }

    public ModelGraph getModelGraph() {
        return this.model;
    }

    public double[] getModelParameter() {
        return this.lambda;
    }

    public boolean saveModelParameter(String filename) {
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(filename));
            out.println(this.lambda.length);
            for (int i = 0; i < this.lambda.length; ++i) {
                out.println(this.lambda[i]);
            }
            out.close();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean readModelParameter(String filename) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(filename));
            int featureNum = Integer.parseInt(in.readLine());
            this.lambda = new double[featureNum];
            int pos = 0;
            while ((line = in.readLine()) != null) {
                this.lambda[pos++] = Double.parseDouble(line);
            }
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void computeTransMatrix(double[] lambda, DataSequence data, int startPos, int endPos, DoubleDenseMatrix transMatrix, boolean takeExp) {
        this.featureGenerator.startScanFeaturesAt(data, startPos, endPos);
        this.computeTransMatrix(lambda, transMatrix, takeExp);
    }

    protected void computeTransMatrix(double[] lambda, DoubleDenseMatrix transMatrix, boolean takeExp) {
        int j;
        int i;
        int stateNum = transMatrix.rows();
        double[] stateFeatureCost = new double[stateNum];
        transMatrix.assign(0.0);
        while (this.featureGenerator.hasNext()) {
            Feature feature = this.featureGenerator.next();
            int label = feature.getLabel();
            int index = feature.getIndex();
            if (feature.getPrevLabel() < 0) {
                int n = label;
                stateFeatureCost[n] = stateFeatureCost[n] + lambda[index] * feature.getValue();
                continue;
            }
            transMatrix.add(feature.getPrevLabel(), label, lambda[index] * feature.getValue());
        }
        for (i = 0; i < stateNum; ++i) {
            for (j = 0; j < stateNum; ++j) {
                transMatrix.setDouble(j, i, transMatrix.getDouble(j, i) + stateFeatureCost[i]);
            }
        }
        if (takeExp) {
            for (i = 0; i < stateNum; ++i) {
                for (j = 0; j < stateNum; ++j) {
                    transMatrix.setDouble(i, j, Math.exp(transMatrix.getDouble(i, j)));
                }
            }
        }
    }
}

