/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix.vector;

import dragon.matrix.DenseMatrix;
import dragon.matrix.SparseMatrix;
import dragon.matrix.vector.DoubleVector;
import java.io.Serializable;
import java.util.Date;

public class PowerMethod
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double tolerance;
    private double dampingFactor;
    private boolean showMessage;
    private int maxIteration;

    public PowerMethod(double tolerance, double dampingFactor) {
        this.tolerance = tolerance;
        this.dampingFactor = dampingFactor;
        this.showMessage = true;
        this.maxIteration = 50;
    }

    public void setMaxIteration(int iteration) {
        this.maxIteration = iteration;
    }

    public int getMaxIteration() {
        return this.maxIteration;
    }

    public DoubleVector getEigenVector(SparseMatrix matrix) {
        int j;
        int len;
        int i;
        DoubleVector oldVector = new DoubleVector(Math.max(matrix.rows(), matrix.columns()));
        DoubleVector newVector = new DoubleVector(oldVector.size());
        oldVector.assign(1.0 / (double)oldVector.size());
        double[] arrRate = new double[matrix.rows()];
        for (i = 0; i < matrix.rows(); ++i) {
            arrRate[i] = 0.0;
            len = matrix.getNonZeroNumInRow(i);
            for (j = 0; j < len; ++j) {
                int n = i;
                arrRate[n] = arrRate[n] + matrix.getNonZeroDoubleScoreInRow(i, j);
            }
            arrRate[i] = (1.0 - this.dampingFactor) / arrRate[i];
        }
        double constFactor = this.dampingFactor / (double)matrix.rows();
        int k = 0;
        while (k < this.maxIteration) {
            if (this.showMessage) {
                System.out.println(new Date() + " iteration " + k);
            }
            ++k;
            newVector.assign(0.0);
            for (i = 0; i < matrix.rows(); ++i) {
                len = matrix.getNonZeroNumInRow(i);
                for (j = 0; j < len; ++j) {
                    double d = arrRate[i] * matrix.getNonZeroDoubleScoreInRow(i, j) + constFactor;
                    int index = matrix.getNonZeroColumnInRow(i, j);
                    newVector.set(index, newVector.get(index) + d * oldVector.get(i));
                }
            }
            double distance = newVector.distance(oldVector);
            System.out.println(distance);
            if (distance < this.tolerance) break;
            oldVector.assign(newVector);
        }
        return newVector;
    }

    public DoubleVector getEigenVector(DenseMatrix matrix) {
        int j;
        int i;
        if (matrix.rows() != matrix.columns()) {
            return null;
        }
        DoubleVector oldVector = new DoubleVector(matrix.rows());
        DoubleVector newVector = new DoubleVector(matrix.rows());
        oldVector.assign(1.0 / (double)matrix.rows());
        double[] arrRate = new double[matrix.rows()];
        for (i = 0; i < matrix.rows(); ++i) {
            arrRate[i] = 0.0;
            for (j = 0; j < matrix.rows(); ++j) {
                int n = i;
                arrRate[n] = arrRate[n] + matrix.getDouble(i, j);
            }
            arrRate[i] = (1.0 - this.dampingFactor) / arrRate[i];
        }
        double constFactor = this.dampingFactor / (double)matrix.rows();
        int k = 0;
        while (k < this.maxIteration) {
            if (this.showMessage) {
                System.out.println(new Date() + " iteration " + k);
            }
            ++k;
            newVector.assign(0.0);
            for (i = 0; i < matrix.rows(); ++i) {
                for (j = 0; j < matrix.rows(); ++j) {
                    double d = arrRate[i] * matrix.getDouble(i, j) + constFactor;
                    newVector.set(j, newVector.get(j) + d * oldVector.get(i));
                }
            }
            if (newVector.distance(oldVector) < this.tolerance) break;
            oldVector.assign(newVector);
        }
        return newVector;
    }

    public void setMessageOption(boolean option) {
        this.showMessage = option;
    }
}

