/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix.vector;

import dragon.util.MathUtil;
import java.io.Serializable;

public class IntVector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] vector;

    public IntVector(int size) {
        this.vector = new int[size];
    }

    public IntVector(int[] vector) {
        this.vector = vector;
    }

    public IntVector copy() {
        int[] newVector = new int[this.vector.length];
        System.arraycopy(this.vector, 0, newVector, 0, this.vector.length);
        return new IntVector(newVector);
    }

    public void assign(int initValue) {
        for (int i = 0; i < this.vector.length; ++i) {
            this.vector[i] = initValue;
        }
    }

    public void assign(IntVector newVector) {
        for (int i = 0; i < this.vector.length; ++i) {
            this.vector[i] = newVector.get(i);
        }
    }

    public void multiply(int rate) {
        int i = 0;
        while (i < this.vector.length) {
            int n = i++;
            this.vector[n] = this.vector[n] * rate;
        }
    }

    public void add(IntVector newVector) {
        if (this.vector.length != newVector.size()) {
            return;
        }
        for (int i = 0; i < this.vector.length; ++i) {
            int n = i;
            this.vector[n] = this.vector[n] + newVector.get(i);
        }
    }

    public void add(int index, int inc) {
        int n = index;
        this.vector[n] = this.vector[n] + inc;
    }

    public int get(int index) {
        return this.vector[index];
    }

    public void set(int index, int value) {
        this.vector[index] = value;
    }

    public int size() {
        return this.vector.length;
    }

    public double distance() {
        int sum = 0;
        for (int i = 0; i < this.vector.length; ++i) {
            sum += this.vector[i] * this.vector[i];
        }
        return Math.sqrt(sum);
    }

    public double distance(IntVector origin) {
        if (this.vector.length != origin.size()) {
            return -1.0;
        }
        int sum = 0;
        for (int i = 0; i < this.vector.length; ++i) {
            int a = this.vector[i] - origin.get(i);
            sum += a * a;
        }
        return Math.sqrt(sum);
    }

    public int[] rank(boolean desc) {
        return MathUtil.rankElementInArray(this.vector, desc);
    }

    public int getDimWithMaxValue() {
        return MathUtil.maxElementInArray(this.vector);
    }

    public int getMaxValue() {
        return MathUtil.max(this.vector);
    }

    public int getMinValue() {
        return MathUtil.min(this.vector);
    }

    public double getAvgValue() {
        return MathUtil.average(this.vector);
    }

    public int getSummation() {
        return MathUtil.sumArray(this.vector);
    }

    public int dotProduct(IntVector newVector) {
        int product = 0;
        for (int i = 0; i < this.vector.length; ++i) {
            product += this.vector[i] * newVector.get(i);
        }
        return product;
    }
}

