/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix.vector;

import dragon.matrix.SparseMatrix;
import dragon.matrix.vector.DoubleVector;
import java.io.Serializable;
import java.util.Date;

public class HITS
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULTITERATION = 20;
    private int numOfIteration;
    private boolean edgeWeightIsCounted;
    private boolean authorityPriorIsSet;
    private boolean hubPriorIsSet;
    private boolean showMessage;
    private DoubleVector authorityVector;
    private DoubleVector hubVector;

    public HITS(boolean edgeWeightIsCounted) {
        this(edgeWeightIsCounted, 20);
    }

    public HITS(boolean edgeWeightIsCounted, int numOfIteration) {
        this.edgeWeightIsCounted = edgeWeightIsCounted;
        this.numOfIteration = numOfIteration;
        this.authorityPriorIsSet = false;
        this.hubPriorIsSet = false;
        this.showMessage = true;
    }

    public void computeAuthorityHub(SparseMatrix matrix) {
        this.computeAuthorityHub(matrix, (SparseMatrix)matrix.transpose());
    }

    public void computeAuthorityHub(SparseMatrix matrix, SparseMatrix tMatrix) {
        if (!this.authorityPriorIsSet) {
            this.authorityVector = new DoubleVector(matrix.columns());
            this.authorityVector.assign(1.0);
        }
        if (!this.hubPriorIsSet) {
            this.hubVector = new DoubleVector(matrix.rows());
            this.hubVector.assign(1.0);
        }
        double[] scoreList = null;
        for (int k = 0; k < this.numOfIteration; ++k) {
            int j;
            double sum;
            int[] indexList;
            int i;
            if (this.showMessage) {
                System.out.println(new Date() + " iteration " + k);
            }
            ++k;
            for (i = 0; i < tMatrix.rows(); ++i) {
                indexList = tMatrix.getNonZeroColumnsInRow(i);
                if (this.edgeWeightIsCounted) {
                    scoreList = tMatrix.getNonZeroDoubleScoresInRow(i);
                }
                sum = 0.0;
                for (j = 0; j < indexList.length; ++j) {
                    if (this.edgeWeightIsCounted) {
                        sum += scoreList[j] * this.hubVector.get(indexList[j]);
                        continue;
                    }
                    sum += this.hubVector.get(indexList[j]);
                }
                this.authorityVector.set(i, sum);
            }
            this.authorityVector.multiply(1.0 / this.authorityVector.distance());
            for (i = 0; i < matrix.rows(); ++i) {
                indexList = matrix.getNonZeroColumnsInRow(i);
                if (this.edgeWeightIsCounted) {
                    scoreList = matrix.getNonZeroDoubleScoresInRow(i);
                }
                sum = 0.0;
                for (j = 0; j < indexList.length; ++j) {
                    if (this.edgeWeightIsCounted) {
                        sum += scoreList[j] * this.authorityVector.get(indexList[j]);
                        continue;
                    }
                    sum += this.authorityVector.get(indexList[j]);
                }
                this.hubVector.set(i, sum);
            }
            this.hubVector.multiply(1.0 / this.hubVector.distance());
        }
    }

    public void setAuthorityVectorPrior(DoubleVector authorityVector) {
        this.authorityVector = authorityVector;
        this.authorityPriorIsSet = true;
    }

    public void setHubVectorPrior(DoubleVector hubVector) {
        this.hubVector = hubVector;
        this.hubPriorIsSet = true;
    }

    public DoubleVector getAuthorityVector() {
        return this.authorityVector;
    }

    public DoubleVector getHubVector() {
        return this.hubVector;
    }

    public void setMessageOption(boolean option) {
        this.showMessage = option;
    }
}

