/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix.vector;

import dragon.util.MathUtil;
import java.io.Serializable;

public class DoubleVector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double[] vector;

    public DoubleVector(int size) {
        this.vector = new double[size];
    }

    public DoubleVector(double[] vector) {
        this.vector = vector;
    }

    public DoubleVector copy() {
        double[] newVector = new double[this.vector.length];
        System.arraycopy(this.vector, 0, newVector, 0, this.vector.length);
        return new DoubleVector(newVector);
    }

    public void assign(double initValue) {
        for (int i = 0; i < this.vector.length; ++i) {
            this.vector[i] = initValue;
        }
    }

    public void assign(DoubleVector newVector) {
        for (int i = 0; i < this.vector.length; ++i) {
            this.vector[i] = newVector.get(i);
        }
    }

    public void multiply(double rate) {
        int i = 0;
        while (i < this.vector.length) {
            int n = i++;
            this.vector[n] = this.vector[n] * rate;
        }
    }

    public void add(DoubleVector newVector) {
        if (this.vector.length != newVector.size()) {
            return;
        }
        for (int i = 0; i < this.vector.length; ++i) {
            int n = i;
            this.vector[n] = this.vector[n] + newVector.get(i);
        }
    }

    public void add(int index, double inc) {
        int n = index;
        this.vector[n] = this.vector[n] + inc;
    }

    public double get(int index) {
        return this.vector[index];
    }

    public void set(int index, double value) {
        this.vector[index] = value;
    }

    public int size() {
        return this.vector.length;
    }

    public double distance() {
        double sum = 0.0;
        for (int i = 0; i < this.vector.length; ++i) {
            sum += this.vector[i] * this.vector[i];
        }
        return Math.sqrt(sum);
    }

    public double distance(DoubleVector origin) {
        if (this.vector.length != origin.size()) {
            return -1.0;
        }
        double sum = 0.0;
        for (int i = 0; i < this.vector.length; ++i) {
            double a = this.vector[i] - origin.get(i);
            sum += a * a;
        }
        return Math.sqrt(sum);
    }

    public int[] rank(boolean desc) {
        return MathUtil.rankElementInArray(this.vector, desc);
    }

    public int getDimWithMaxValue() {
        return MathUtil.maxElementInArray(this.vector);
    }

    public double getMaxValue() {
        return MathUtil.max(this.vector);
    }

    public double getMinValue() {
        return MathUtil.min(this.vector);
    }

    public double getAvgValue() {
        return MathUtil.average(this.vector);
    }

    public double getSummation() {
        return MathUtil.sumArray(this.vector);
    }

    public double dotProduct(DoubleVector newVector) {
        double product = 0.0;
        for (int i = 0; i < this.vector.length; ++i) {
            product += this.vector[i] * newVector.get(i);
        }
        return product;
    }
}

