/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix.factorize;

import dragon.matrix.DoubleDenseMatrix;
import dragon.matrix.DoubleFlatDenseMatrix;
import dragon.matrix.SparseMatrix;
import dragon.matrix.factorize.AbstractFactorization;

public class NMF
extends AbstractFactorization {
    private SparseMatrix xt;
    private DoubleDenseMatrix u;
    private DoubleDenseMatrix m;
    private DoubleDenseMatrix v;
    private int iterations;

    public NMF(int iterations) {
        this.iterations = iterations;
    }

    @Override
    public void factorize(SparseMatrix x, int dimension) {
        DoubleFlatDenseMatrix vtv;
        this.xt = (SparseMatrix)x.transpose();
        this.u = this.genPositiveMatrix(x.rows(), dimension);
        this.v = this.genPositiveMatrix(x.columns(), dimension);
        DoubleFlatDenseMatrix xv = new DoubleFlatDenseMatrix(x.rows(), dimension);
        DoubleFlatDenseMatrix vt = new DoubleFlatDenseMatrix(dimension, x.columns());
        DoubleFlatDenseMatrix utu = vtv = new DoubleFlatDenseMatrix(dimension, dimension);
        DoubleFlatDenseMatrix uvtv = new DoubleFlatDenseMatrix(x.rows(), dimension);
        DoubleFlatDenseMatrix xtu = new DoubleFlatDenseMatrix(x.columns(), dimension);
        DoubleFlatDenseMatrix ut = new DoubleFlatDenseMatrix(dimension, x.rows());
        DoubleFlatDenseMatrix vutu = new DoubleFlatDenseMatrix(x.columns(), dimension);
        for (int k = 0; k < this.iterations; ++k) {
            double score;
            int j;
            int i;
            this.product(x, this.v, (DoubleDenseMatrix)xv);
            this.transpose(this.v, vt);
            this.product(vt, this.v, (DoubleDenseMatrix)vtv);
            this.product(this.u, (DoubleDenseMatrix)vtv, (DoubleDenseMatrix)uvtv);
            this.product(this.xt, this.u, (DoubleDenseMatrix)xtu);
            this.transpose(this.u, ut);
            this.product(ut, this.u, (DoubleDenseMatrix)utu);
            this.product(this.v, (DoubleDenseMatrix)utu, (DoubleDenseMatrix)vutu);
            for (i = 0; i < this.v.rows(); ++i) {
                for (j = 0; j < this.v.columns(); ++j) {
                    score = vutu.getDouble(i, j) + 1.0E-9;
                    score = this.v.getDouble(i, j) * xtu.getDouble(i, j) / score;
                    this.v.setDouble(i, j, score);
                }
            }
            for (i = 0; i < this.u.rows(); ++i) {
                for (j = 0; j < this.u.columns(); ++j) {
                    score = uvtv.getDouble(i, j) + 1.0E-9;
                    score = this.u.getDouble(i, j) * xv.getDouble(i, j) / score;
                    this.u.setDouble(i, j, score);
                }
            }
            this.normalizeColumn(this.u);
        }
    }

    @Override
    public DoubleDenseMatrix getLeftMatrix() {
        return this.u;
    }

    @Override
    public DoubleDenseMatrix getRightMatrix() {
        return this.v;
    }

    @Override
    public DoubleDenseMatrix getMiddleMatrix() {
        return this.m;
    }
}

