/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix.factorize;

import dragon.matrix.DoubleDenseMatrix;
import dragon.matrix.DoubleFlatDenseMatrix;
import dragon.matrix.SparseMatrix;
import dragon.matrix.factorize.Factorization;
import java.util.Random;

public abstract class AbstractFactorization
implements Factorization {
    public static final double SMALL_QUANTITY = 1.0E-9;

    protected DoubleDenseMatrix genPositiveMatrix(int x, int y) {
        Random rand = new Random(1L);
        DoubleFlatDenseMatrix matrix = new DoubleFlatDenseMatrix(x, y);
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                matrix.setDouble(i, j, rand.nextDouble() + 1.0E-9);
            }
        }
        return matrix;
    }

    protected void product(DoubleDenseMatrix a, DoubleDenseMatrix b, DoubleDenseMatrix c) {
        for (int row = 0; row < a.rows(); ++row) {
            for (int col = 0; col < b.columns(); ++col) {
                double score = 0.0;
                for (int i = 0; i < a.columns(); ++i) {
                    score += a.getDouble(row, i) * b.getDouble(i, col);
                }
                c.setDouble(row, col, score);
            }
        }
    }

    protected void product(SparseMatrix a, DoubleDenseMatrix b, DoubleDenseMatrix c) {
        for (int row = 0; row < a.rows(); ++row) {
            int[] arrColumn = a.getNonZeroColumnsInRow(row);
            double[] arrScore = a.getNonZeroDoubleScoresInRow(row);
            for (int col = 0; col < b.columns(); ++col) {
                double score = 0.0;
                for (int i = 0; i < arrColumn.length; ++i) {
                    score += arrScore[i] * b.getDouble(arrColumn[i], col);
                }
                c.setDouble(row, col, score);
            }
        }
    }

    protected void transpose(DoubleDenseMatrix a, DoubleDenseMatrix at) {
        for (int row = 0; row < a.rows(); ++row) {
            for (int col = 0; col < a.columns(); ++col) {
                at.setDouble(col, row, a.getDouble(row, col));
            }
        }
    }

    protected void normalizeColumn(DoubleDenseMatrix a) {
        for (int col = 0; col < a.columns(); ++col) {
            double score;
            int row;
            double norm = 0.0;
            for (row = 0; row < a.rows(); ++row) {
                score = a.getDouble(row, col);
                norm += score * score;
            }
            norm = Math.sqrt(norm);
            for (row = 0; row < a.rows(); ++row) {
                score = a.getDouble(row, col);
                a.setDouble(row, col, score / norm);
            }
        }
    }
}

