/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractFlatSparseMatrix;
import dragon.matrix.AbstractSuperSparseMatrix;
import dragon.matrix.Cell;
import dragon.matrix.IntCell;
import dragon.matrix.IntFlatSparseMatrix;
import dragon.matrix.IntRow;
import dragon.matrix.IntSparseMatrix;
import dragon.matrix.Row;
import dragon.matrix.SparseMatrix;
import dragon.util.FileUtil;

public class IntSuperSparseMatrix
extends AbstractSuperSparseMatrix
implements IntSparseMatrix {
    private static final long serialVersionUID = 1L;

    public IntSuperSparseMatrix(String matrixFile) {
        super(null, matrixFile, IntCell.getCellDataLength());
    }

    public IntSuperSparseMatrix(String indexFile, String matrixFile) {
        super(indexFile, matrixFile, IntCell.getCellDataLength());
    }

    public IntSuperSparseMatrix(String matrixFile, boolean mergeMode, boolean miniMode) {
        super(null, matrixFile, IntCell.getCellDataLength(), mergeMode, miniMode);
    }

    public IntSuperSparseMatrix(String indexFile, String matrixFile, boolean mergeMode, boolean miniMode) {
        super(indexFile, matrixFile, IntCell.getCellDataLength(), mergeMode, miniMode);
    }

    @Override
    public SparseMatrix createSparseMatrix() {
        String indexFile = FileUtil.getNewTempFilename("newmatrix", "index");
        String matrixFile = FileUtil.getNewTempFilename("newmatrix", "matrix");
        return new IntSuperSparseMatrix(indexFile, matrixFile, false, false);
    }

    @Override
    protected AbstractFlatSparseMatrix createFlatSparseMatrix(boolean mergeMode, boolean miniMode) {
        return new IntFlatSparseMatrix(mergeMode, miniMode);
    }

    @Override
    protected Row createRow(int row, int columns, byte[] data) {
        IntRow cur = new IntRow();
        cur.load(row, columns, data);
        return cur;
    }

    @Override
    public Cell createCell(int row, int column, byte[] data) {
        IntCell cur = new IntCell(row, column);
        cur.fromByteArray(data);
        return cur;
    }

    @Override
    public Cell createCell(int row, int column, String data) {
        IntCell cur = new IntCell(row, column);
        cur.fromString(data);
        return cur;
    }

    @Override
    public boolean add(int row, int column, int score) {
        return this.add(new IntCell(row, column, score));
    }

    @Override
    public int getInt(int row, int column) {
        if (row >= this.rows) {
            return 0;
        }
        return ((IntRow)this.getRow(row)).getInt(column);
    }

    @Override
    public int getNonZeroIntScoreInRow(int row, int index) {
        if (row >= this.rows) {
            return 0;
        }
        return ((IntRow)this.getRow(row)).getNonZeroIntScore(index);
    }

    @Override
    public int[] getNonZeroIntScoresInRow(int row) {
        if (row >= this.rows) {
            return null;
        }
        int[] oldArray = ((IntRow)this.getRow(row)).getNonZeroIntScores();
        int[] newArray = new int[oldArray.length];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }

    @Override
    public double[] getNonZeroDoubleScoresInRow(int row) {
        if (row >= this.rows) {
            return null;
        }
        int[] oldArray = ((IntRow)this.getRow(row)).getNonZeroIntScores();
        if (oldArray == null) {
            return null;
        }
        double[] newArray = new double[oldArray.length];
        for (int i = 0; i < oldArray.length; ++i) {
            newArray[i] = oldArray[i];
        }
        return newArray;
    }

    @Override
    public long getRowSum(int row) {
        long sum = 0L;
        int[] scores = this.getNonZeroIntScoresInRow(row);
        for (int count = 0; count < scores.length; ++count) {
            sum += (long)scores[count];
        }
        return sum;
    }

    public long getColumnSum(int column) {
        return ((IntSuperSparseMatrix)this.transpose()).getRowSum(column);
    }
}

