/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractFlatSparseMatrix;
import dragon.matrix.Cell;
import dragon.matrix.IntCell;
import dragon.matrix.IntSparseMatrix;
import dragon.matrix.SparseMatrix;
import java.io.Serializable;

public class IntFlatSparseMatrix
extends AbstractFlatSparseMatrix
implements IntSparseMatrix,
Serializable {
    private static final long serialVersionUID = 1L;

    public IntFlatSparseMatrix() {
        super(false, false, IntCell.getCellDataLength());
    }

    public IntFlatSparseMatrix(boolean mergeMode, boolean miniMode) {
        super(mergeMode, miniMode, IntCell.getCellDataLength());
    }

    public IntFlatSparseMatrix(String filename) {
        super(false, false, IntCell.getCellDataLength());
        this.readTextMatrixFile(filename);
    }

    public IntFlatSparseMatrix(String filename, boolean binaryFile) {
        super(false, false, IntCell.getCellDataLength());
        if (binaryFile) {
            this.readBinaryMatrixFile(filename);
        } else {
            this.readTextMatrixFile(filename);
        }
    }

    @Override
    public SparseMatrix createSparseMatrix() {
        return new IntFlatSparseMatrix();
    }

    @Override
    public Cell createCell(int row, int column, byte[] data) {
        IntCell cur = new IntCell(row, column);
        cur.fromByteArray(data);
        return cur;
    }

    @Override
    public Cell createCell(int row, int column, String data) {
        IntCell cur = new IntCell(row, column);
        cur.fromString(data);
        return cur;
    }

    @Override
    public boolean add(int row, int column, int score) {
        return this.add(new IntCell(row, column, score));
    }

    @Override
    public long getRowSum(int row) {
        long sum = 0L;
        int num = this.getNonZeroNumInRow(row);
        for (int count = 0; count < num; ++count) {
            sum += (long)this.getNonZeroIntScoreInRow(row, count);
        }
        return sum;
    }

    public long getColumnSum(int column) {
        return ((IntFlatSparseMatrix)this.transpose()).getRowSum(column);
    }
}

