/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractDenseMatrix;
import dragon.matrix.IntDenseMatrix;
import dragon.util.FastBinaryReader;
import dragon.util.FastBinaryWriter;
import dragon.util.FileUtil;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Serializable;

public class IntFlatDenseMatrix
extends AbstractDenseMatrix
implements IntDenseMatrix,
Serializable {
    private static final long serialVersionUID = 1L;
    private int[][] arrMatrix;

    public IntFlatDenseMatrix(int[][] newMatrix) {
        super(newMatrix.length, newMatrix[0].length, 4);
        this.arrMatrix = newMatrix;
    }

    public IntFlatDenseMatrix(int row, int column) {
        super(row, column, 4);
        this.arrMatrix = new int[row][column];
    }

    public IntFlatDenseMatrix(String filename) {
        super(-1, -1, 4);
        this.readTextMatrixFile(filename);
    }

    public IntFlatDenseMatrix(String filename, boolean binaryFile) {
        super(-1, -1, 4);
        if (binaryFile) {
            this.readBinMatrixFile(filename);
        } else {
            this.readTextMatrixFile(filename);
        }
    }

    @Override
    public void assign(int val) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.arrMatrix[i][j] = val;
            }
        }
    }

    @Override
    public boolean add(int row, int column, int score) {
        if (row > this.rows || column > this.columns) {
            return false;
        }
        int[] nArray = this.arrMatrix[row];
        int n = column;
        nArray[n] = nArray[n] + score;
        return true;
    }

    @Override
    public boolean setInt(int row, int column, int score) {
        if (row > this.rows || column > this.columns) {
            return false;
        }
        this.arrMatrix[row][column] = score;
        return true;
    }

    @Override
    public long getRowSum(int row) {
        long sum = 0L;
        for (int i = 0; i < this.columns; ++i) {
            sum += (long)this.arrMatrix[row][i];
        }
        return sum;
    }

    @Override
    public long getColumnSum(int column) {
        long sum = 0L;
        for (int i = 0; i < this.rows; ++i) {
            sum += (long)this.arrMatrix[i][column];
        }
        return sum;
    }

    @Override
    public int getInt(int row, int column) {
        return this.arrMatrix[row][column];
    }

    @Override
    public double getDouble(int row, int column) {
        return this.arrMatrix[row][column];
    }

    public void saveTo(String filename, boolean binary) {
        if (!binary) {
            this.saveTo(filename);
            return;
        }
        FastBinaryWriter fastBinWriter = new FastBinaryWriter(filename);
        try {
            fastBinWriter.writeInt(this.rows);
            fastBinWriter.writeInt(this.columns);
            fastBinWriter.writeInt(this.rows * this.columns);
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    fastBinWriter.writeInt(this.arrMatrix[i][j]);
                }
                if (i % 100 != 0) continue;
                fastBinWriter.flush();
            }
            fastBinWriter.flush();
            fastBinWriter.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveTo(String filename) {
        this.print(FileUtil.getPrintWriter(filename));
    }

    public void print(PrintWriter out) {
        try {
            out.write(String.valueOf(this.rows) + "," + String.valueOf(this.columns) + "," + String.valueOf(this.rows * this.columns) + "\n");
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    out.write(String.valueOf(this.arrMatrix[i][j]) + ",");
                }
                out.write("\n");
                if (i % 100 != 0) continue;
                out.flush();
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readTextMatrixFile(String fileName) {
        BufferedReader br = FileUtil.getTextReader(fileName);
        try {
            String line = br.readLine();
            String[] arrLine = line.split(",");
            this.rows = Integer.parseInt(arrLine[0]);
            this.columns = Integer.parseInt(arrLine[1]);
            this.arrMatrix = new int[this.rows][this.columns];
            int i = 0;
            while ((line = br.readLine()) != null) {
                arrLine = line.split(",");
                for (int j = 0; j < this.arrMatrix[0].length; ++j) {
                    this.arrMatrix[i][j] = Integer.parseInt(arrLine[j]);
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void readBinMatrixFile(String fileName) {
        FastBinaryReader fbr = new FastBinaryReader(fileName);
        try {
            this.rows = fbr.readInt();
            this.columns = fbr.readInt();
            this.arrMatrix = new int[this.rows][this.columns];
            fbr.readInt();
            for (int i = 0; i < this.arrMatrix.length; ++i) {
                for (int j = 0; j < this.arrMatrix[0].length; ++j) {
                    this.arrMatrix[i][j] = fbr.readInt();
                }
            }
            fbr.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void close() {
        this.rows = 0;
        this.columns = 0;
        this.arrMatrix = null;
    }
}

