/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractCell;
import dragon.matrix.Cell;
import dragon.util.ByteArrayConvert;
import java.io.Serializable;

public class IntCell
extends AbstractCell
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int row;
    protected int col;
    protected int score;

    public IntCell(int row, int column, int score) {
        this.row = row;
        this.col = column;
        this.score = score;
    }

    public IntCell(int row, int column) {
        this.row = row;
        this.col = column;
        this.score = 0;
    }

    public static int getCellDataLength() {
        return 4;
    }

    @Override
    public void merge(Cell cell) {
        this.score = cell.getResetOption() ? cell.getIntScore() : (this.score += cell.getIntScore());
    }

    @Override
    public byte[] toByteArray() {
        return ByteArrayConvert.toByte(this.score);
    }

    @Override
    public void fromByteArray(byte[] data) {
        this.score = ByteArrayConvert.toInt(data);
    }

    @Override
    public String toString() {
        return String.valueOf(this.score);
    }

    @Override
    public void fromString(String data) {
        this.score = Integer.parseInt(data);
    }

    @Override
    public Cell transpose() {
        return new IntCell(this.col, this.row, this.score);
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getColumn() {
        return this.col;
    }

    @Override
    public double getDoubleScore() {
        return this.score;
    }

    @Override
    public int getIntScore() {
        return this.score;
    }

    @Override
    public long getLongScore() {
        return this.score;
    }

    @Override
    public byte getByteScore() {
        return (byte)this.score;
    }

    public void setScore(double score) {
        this.score = (int)score;
    }

    @Override
    public void setDoubleScore(double score) {
        this.score = (int)score;
    }

    @Override
    public void setIntScore(int score) {
        this.score = score;
    }

    @Override
    public void setLongScore(long score) {
        this.score = (int)score;
    }

    @Override
    public void setByteScore(byte score) {
        this.score = score;
    }
}

