/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractFlatSparseMatrix;
import dragon.matrix.AbstractSuperSparseMatrix;
import dragon.matrix.Cell;
import dragon.matrix.DoubleCell;
import dragon.matrix.DoubleFlatSparseMatrix;
import dragon.matrix.DoubleRow;
import dragon.matrix.DoubleSparseMatrix;
import dragon.matrix.Row;
import dragon.matrix.SparseMatrix;
import dragon.util.FileUtil;

public class DoubleSuperSparseMatrix
extends AbstractSuperSparseMatrix
implements DoubleSparseMatrix {
    private static final long serialVersionUID = 1L;

    public DoubleSuperSparseMatrix(String matrixFile) {
        super(null, matrixFile, DoubleCell.getCellDataLength());
    }

    public DoubleSuperSparseMatrix(String indexFile, String matrixFile) {
        super(indexFile, matrixFile, DoubleCell.getCellDataLength());
    }

    public DoubleSuperSparseMatrix(String matrixFile, boolean mergeMode, boolean miniMode) {
        super(null, matrixFile, DoubleCell.getCellDataLength(), mergeMode, miniMode);
    }

    public DoubleSuperSparseMatrix(String indexFile, String matrixFile, boolean mergeMode, boolean miniMode) {
        super(indexFile, matrixFile, DoubleCell.getCellDataLength(), mergeMode, miniMode);
    }

    @Override
    public SparseMatrix createSparseMatrix() {
        String indexFile = FileUtil.getNewTempFilename("newmatrix", "index");
        String matrixFile = FileUtil.getNewTempFilename("newmatrix", "matrix");
        return new DoubleSuperSparseMatrix(indexFile, matrixFile, false, false);
    }

    @Override
    protected AbstractFlatSparseMatrix createFlatSparseMatrix(boolean mergeMode, boolean miniMode) {
        return new DoubleFlatSparseMatrix(mergeMode, miniMode);
    }

    @Override
    protected Row createRow(int row, int columns, byte[] data) {
        DoubleRow cur = new DoubleRow();
        cur.load(row, columns, data);
        return cur;
    }

    @Override
    public Cell createCell(int row, int column, byte[] data) {
        DoubleCell cur = new DoubleCell(row, column);
        cur.fromByteArray(data);
        return cur;
    }

    @Override
    public Cell createCell(int row, int column, String data) {
        DoubleCell cur = new DoubleCell(row, column);
        cur.fromString(data);
        return cur;
    }

    @Override
    public boolean add(int row, int column, double score) {
        return this.add(new DoubleCell(row, column, score));
    }

    @Override
    public double getDouble(int row, int column) {
        if (row >= this.rows) {
            return 0.0;
        }
        return ((DoubleRow)this.getRow(row)).getDouble(column);
    }

    @Override
    public double getNonZeroDoubleScoreInRow(int row, int index) {
        if (row >= this.rows) {
            return 0.0;
        }
        return ((DoubleRow)this.getRow(row)).getNonZeroDoubleScore(index);
    }

    @Override
    public double[] getNonZeroDoubleScoresInRow(int row) {
        if (row >= this.rows) {
            return null;
        }
        double[] oldArray = ((DoubleRow)this.getRow(row)).getNonZeroDoubleScores();
        double[] newArray = new double[oldArray.length];
        System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
        return newArray;
    }

    @Override
    public double getRowSum(int row) {
        double sum = 0.0;
        double[] scores = this.getNonZeroDoubleScoresInRow(row);
        for (int count = 0; count < scores.length; ++count) {
            sum += scores[count];
        }
        return sum;
    }

    public double getColumnSum(int column) {
        return ((DoubleSuperSparseMatrix)this.transpose()).getRowSum(column);
    }
}

