/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractRow;
import dragon.matrix.Cell;
import dragon.matrix.DoubleCell;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.Serializable;

public class DoubleRow
extends AbstractRow
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int[] columns;
    private double[] scores;

    public DoubleRow() {
        this.length = 0;
        this.row = -1;
        this.columns = null;
        this.scores = null;
        this.loadFactor = 0.0f;
    }

    public DoubleRow(int row, int num, int[] columns, double[] scores) {
        this.length = num;
        this.row = row;
        this.columns = columns;
        this.scores = scores;
        this.loadFactor = 0.0f;
    }

    @Override
    public void load(int row, int num, byte[] data) {
        try {
            this.row = row;
            this.length = num;
            this.columns = new int[num];
            this.scores = new double[num];
            DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
            for (int i = 0; i < num; ++i) {
                this.columns[i] = dis.readInt();
                this.scores[i] = dis.readDouble();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public int[] getNonZeroColumns() {
        return this.columns;
    }

    @Override
    public int getNonZeroColumn(int index) {
        return this.columns[index];
    }

    public double[] getNonZeroDoubleScores() {
        return this.scores;
    }

    @Override
    public double getNonZeroDoubleScore(int index) {
        return this.scores[index];
    }

    @Override
    public int getNonZeroIntScore(int index) {
        return (int)this.scores[index];
    }

    public void setNonZeroDoubleScore(int index, double score) {
        this.scores[index] = score;
    }

    public double getDouble(int column) {
        int index = this.getColumnIndex(column);
        if (index >= 0) {
            return this.scores[index];
        }
        return 0.0;
    }

    @Override
    public Cell getNonZeroCell(int index) {
        return new DoubleCell(this.row, this.columns[index], this.scores[index]);
    }

    @Override
    public Cell getCell(int column) {
        int index = this.getColumnIndex(column);
        if (index >= 0) {
            return this.getNonZeroCell(index);
        }
        return null;
    }

    private int getColumnIndex(int column) {
        int low = 0;
        int high = this.length - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            int curColumn = this.columns[middle];
            if (curColumn == column) {
                return middle;
            }
            if (curColumn < column) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        return -1;
    }
}

