/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractFlatSparseMatrix;
import dragon.matrix.Cell;
import dragon.matrix.DoubleCell;
import dragon.matrix.DoubleDenseMatrix;
import dragon.matrix.DoubleFlatDenseMatrix;
import dragon.matrix.DoubleSparseMatrix;
import dragon.matrix.SparseMatrix;
import java.io.Serializable;

public class DoubleFlatSparseMatrix
extends AbstractFlatSparseMatrix
implements DoubleSparseMatrix,
Serializable {
    private static final long serialVersionUID = 1L;

    public DoubleFlatSparseMatrix() {
        super(false, false, DoubleCell.getCellDataLength());
    }

    public DoubleFlatSparseMatrix(boolean mergeMode, boolean miniMode) {
        super(mergeMode, miniMode, DoubleCell.getCellDataLength());
    }

    public DoubleFlatSparseMatrix(String filename) {
        super(false, false, DoubleCell.getCellDataLength());
        this.readTextMatrixFile(filename);
    }

    public DoubleFlatSparseMatrix(String filename, boolean binaryFile) {
        super(false, false, DoubleCell.getCellDataLength());
        if (binaryFile) {
            this.readBinaryMatrixFile(filename);
        } else {
            this.readTextMatrixFile(filename);
        }
    }

    @Override
    public SparseMatrix createSparseMatrix() {
        return new DoubleFlatSparseMatrix();
    }

    @Override
    public Cell createCell(int row, int column, byte[] data) {
        DoubleCell cur = new DoubleCell(row, column);
        cur.fromByteArray(data);
        return cur;
    }

    @Override
    public Cell createCell(int row, int column, String data) {
        DoubleCell cur = new DoubleCell(row, column);
        cur.fromString(data);
        return cur;
    }

    @Override
    public boolean add(int row, int column, double value) {
        return this.add(new DoubleCell(row, column, value));
    }

    public double get(int row, int column) {
        return this.getDouble(row, column);
    }

    public void set(int row, int column, double score) {
        this.setDouble(row, column, score);
    }

    public double getQuick(int row, int column) {
        return this.getDouble(row, column);
    }

    public void setQuick(int row, int column, double score) {
        this.setDouble(row, column, score);
    }

    @Override
    public double getRowSum(int row) {
        double sum = 0.0;
        int num = this.getNonZeroNumInRow(row);
        for (int count = 0; count < num; ++count) {
            sum += this.getNonZeroDoubleScoreInRow(row, count);
        }
        return sum;
    }

    public double getColumnSum(int column) {
        return ((DoubleFlatSparseMatrix)this.transpose()).getRowSum(column);
    }

    public void normalizeColumns() {
        int i;
        DoubleFlatSparseMatrix matrix = (DoubleFlatSparseMatrix)this.transpose();
        double[] arrNorm = new double[this.columns];
        for (i = 0; i < matrix.rows(); ++i) {
            double score;
            int j;
            arrNorm[i] = 0.0;
            int num = matrix.getNonZeroNumInRow(i);
            for (j = 0; j < num; ++j) {
                score = matrix.getNonZeroDoubleScoreInRow(i, j);
                int n = i;
                arrNorm[n] = arrNorm[n] + score * score;
            }
            arrNorm[i] = Math.sqrt(arrNorm[i]);
            for (j = 0; j < num; ++j) {
                score = matrix.getNonZeroDoubleScoreInRow(i, j);
                matrix.setNonZeroDoubleScoreInRow(i, j, score);
            }
        }
        for (i = 0; i < this.list.size(); ++i) {
            DoubleCell cur = (DoubleCell)this.getNonZeroCell(i);
            cur.setDoubleScore(cur.getDoubleScore() / arrNorm[cur.getColumn()]);
        }
    }

    public void normalizeRows() {
        ((DoubleFlatSparseMatrix)this.transpose()).normalizeColumns();
    }

    public DoubleDenseMatrix product(DoubleFlatSparseMatrix matrixY) {
        DoubleFlatSparseMatrix matrixX = this;
        if (matrixX.columns() != matrixY.rows()) {
            return null;
        }
        DoubleFlatDenseMatrix output = new DoubleFlatDenseMatrix(this.rows, matrixY.columns());
        for (int i = 0; i < matrixX.rows(); ++i) {
            for (int j = 0; j < matrixY.columns(); ++j) {
                double score = 0.0;
                int x = 0;
                int y = 0;
                int xNum = matrixX.getNonZeroNumInRow(i);
                int yNum = matrixY.getNonZeroNumInColumn(j);
                while (x < xNum && y < yNum) {
                    int yCol;
                    int xCol = matrixX.getNonZeroColumnInRow(i, x);
                    if (xCol < (yCol = matrixY.getNonZeroRowInColumn(j, y))) {
                        ++x;
                        continue;
                    }
                    if (xCol == yCol) {
                        score += matrixX.getNonZeroDoubleScoreInRow(i, ++x) * matrixY.getNonZeroDoubleScoreInColumn(j, ++y);
                        continue;
                    }
                    ++y;
                }
                output.setDouble(i, j, score);
            }
        }
        return output;
    }

    public DoubleDenseMatrix product(DoubleDenseMatrix b) {
        DoubleFlatDenseMatrix output = new DoubleFlatDenseMatrix(this.rows, b.columns());
        for (int row = 0; row < this.rows(); ++row) {
            int[] arrColumn = this.getNonZeroColumnsInRow(row);
            double[] arrScore = this.getNonZeroDoubleScoresInRow(row);
            for (int col = 0; col < b.columns(); ++col) {
                double score = 0.0;
                for (int i = 0; i < arrColumn.length; ++i) {
                    score += arrScore[i] * b.getDouble(arrColumn[i], col);
                }
                output.setDouble(row, col, score);
            }
        }
        return output;
    }
}

