/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractCell;
import dragon.matrix.Cell;
import dragon.util.ByteArrayConvert;
import java.io.Serializable;

public class DoubleCell
extends AbstractCell
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int row;
    protected int col;
    protected double score;

    public DoubleCell(int row, int column) {
        this.row = row;
        this.col = column;
        this.score = 0.0;
    }

    public DoubleCell(int row, int column, double score) {
        this.row = row;
        this.col = column;
        this.score = score;
    }

    public static int getCellDataLength() {
        return 8;
    }

    @Override
    public void merge(Cell cell) {
        this.score = cell.getResetOption() ? cell.getDoubleScore() : (this.score += cell.getDoubleScore());
    }

    @Override
    public byte[] toByteArray() {
        return ByteArrayConvert.toByte(this.score);
    }

    @Override
    public void fromByteArray(byte[] data) {
        this.score = ByteArrayConvert.toDouble(data);
    }

    @Override
    public String toString() {
        return String.valueOf(this.score);
    }

    @Override
    public void fromString(String data) {
        this.score = Double.parseDouble(data);
    }

    @Override
    public Cell transpose() {
        return new DoubleCell(this.col, this.row, this.score);
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public int getColumn() {
        return this.col;
    }

    @Override
    public double getDoubleScore() {
        return this.score;
    }

    @Override
    public int getIntScore() {
        return (int)this.score;
    }

    @Override
    public long getLongScore() {
        return (long)this.score;
    }

    @Override
    public byte getByteScore() {
        return (byte)this.score;
    }

    @Override
    public void setDoubleScore(double score) {
        this.score = score;
    }

    @Override
    public void setIntScore(int score) {
        this.score = score;
    }

    @Override
    public void setLongScore(long score) {
        this.score = score;
    }

    @Override
    public void setByteScore(byte score) {
        this.score = score;
    }
}

