/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractMatrix;
import dragon.matrix.Cell;
import dragon.matrix.DoubleSparseMatrix;
import dragon.matrix.IntSparseMatrix;
import dragon.matrix.Matrix;
import dragon.matrix.SparseMatrix;
import java.io.Serializable;
import java.util.Date;

public abstract class AbstractSparseMatrix
extends AbstractMatrix
implements SparseMatrix,
Serializable {
    protected boolean isFinalized;
    protected boolean mergeMode;
    protected boolean miniMode;

    public AbstractSparseMatrix(boolean mergeMode, boolean miniMode, int cellDataLength) {
        this.mergeMode = mergeMode;
        this.miniMode = miniMode;
        this.cellDataLength = cellDataLength;
        this.transposeMatrix = null;
        this.isFinalized = false;
    }

    @Override
    public boolean isFinalized() {
        return this.isFinalized;
    }

    @Override
    public boolean finalizeData() {
        return this.finalizeData(true);
    }

    @Override
    public Cell getNonZeroCellInColumn(int column, int index) {
        return ((SparseMatrix)this.transpose()).getNonZeroCellInRow(column, index);
    }

    @Override
    public int getNonZeroNumInColumn(int column) {
        return ((SparseMatrix)this.transpose()).getNonZeroNumInRow(column);
    }

    @Override
    public int getNonZeroRowInColumn(int column, int index) {
        return ((SparseMatrix)this.transpose()).getNonZeroColumnInRow(column, index);
    }

    @Override
    public int[] getNonZeroRowsInColumn(int column) {
        return ((SparseMatrix)this.transpose()).getNonZeroColumnsInRow(column);
    }

    @Override
    public double getDouble(int row, int column) {
        Cell curCell = this.getCell(row, column);
        if (curCell != null) {
            return curCell.getDoubleScore();
        }
        return 0.0;
    }

    @Override
    public int getInt(int row, int column) {
        Cell curCell = this.getCell(row, column);
        if (curCell != null) {
            return curCell.getIntScore();
        }
        return 0;
    }

    @Override
    public double getNonZeroDoubleScoreInColumn(int column, int index) {
        return ((SparseMatrix)this.transpose()).getNonZeroDoubleScoreInRow(column, index);
    }

    @Override
    public double[] getNonZeroDoubleScoresInColumn(int column) {
        return ((SparseMatrix)this.transpose()).getNonZeroDoubleScoresInRow(column);
    }

    @Override
    public int getNonZeroIntScoreInColumn(int column, int index) {
        return ((SparseMatrix)this.transpose()).getNonZeroIntScoreInRow(column, index);
    }

    @Override
    public int[] getNonZeroIntScoresInColumn(int column) {
        return ((SparseMatrix)this.transpose()).getNonZeroIntScoresInRow(column);
    }

    @Override
    public double getNonZeroDoubleScoreInRow(int row, int index) {
        return this.getNonZeroCellInRow(row, index).getDoubleScore();
    }

    @Override
    public int getNonZeroIntScoreInRow(int row, int index) {
        return this.getNonZeroCellInRow(row, index).getIntScore();
    }

    @Override
    public double[] getNonZeroDoubleScoresInRow(int row) {
        int num = this.getNonZeroNumInRow(row);
        double[] arrScore = new double[num];
        for (int count = 0; count < num; ++count) {
            arrScore[count] = this.getNonZeroCellInRow(row, count).getDoubleScore();
        }
        return arrScore;
    }

    @Override
    public int[] getNonZeroIntScoresInRow(int row) {
        int num = this.getNonZeroNumInRow(row);
        int[] arrScore = new int[num];
        for (int count = 0; count < num; ++count) {
            arrScore[count] = this.getNonZeroCellInRow(row, count).getIntScore();
        }
        return arrScore;
    }

    @Override
    public boolean genCooccurrenceMatrix(IntSparseMatrix outputCooccurMatrix) {
        return this.genCooccurrenceMatrix(this, 1, outputCooccurMatrix);
    }

    @Override
    public boolean genCooccurrenceMatrix(SparseMatrix matrixY, IntSparseMatrix outputCooccurMatrix) {
        return this.genCooccurrenceMatrix(matrixY, 1, outputCooccurMatrix);
    }

    @Override
    public boolean genCooccurrenceMatrix(SparseMatrix matrixY, int minOccurrence, IntSparseMatrix outputCooccurMatrix) {
        AbstractSparseMatrix matrixX = this;
        if (matrixX.columns() != matrixY.columns()) {
            return false;
        }
        boolean equal = matrixX.equals(matrixY);
        for (int i = 0; i < matrixX.rows(); ++i) {
            int j;
            System.out.println(new Date().toString() + " Processing Row " + i);
            int[] arrColumnX = matrixX.getNonZeroColumnsInRow(i);
            int xNum = matrixX.getNonZeroNumInRow(i);
            int n = j = equal ? i + 1 : 0;
            while (j < matrixY.rows()) {
                int coOccurCount = 0;
                int x = 0;
                int y = 0;
                int[] arrColumnY = matrixY.getNonZeroColumnsInRow(j);
                int yNum = matrixY.getNonZeroNumInRow(j);
                while (x < xNum && y < yNum) {
                    if (arrColumnX[x] < arrColumnY[y]) {
                        ++x;
                        continue;
                    }
                    if (arrColumnX[x] == arrColumnY[y]) {
                        ++x;
                        ++y;
                        ++coOccurCount;
                        continue;
                    }
                    ++y;
                }
                if (coOccurCount >= minOccurrence) {
                    outputCooccurMatrix.add(i, j, coOccurCount);
                    if (equal) {
                        outputCooccurMatrix.add(i, i, xNum);
                        outputCooccurMatrix.add(j, i, coOccurCount);
                    }
                }
                ++j;
            }
        }
        if (equal) {
            outputCooccurMatrix.finalizeData();
        } else {
            outputCooccurMatrix.finalizeData(false);
        }
        return true;
    }

    @Override
    public int getCooccurrenceCount(int rowA, int rowB) {
        int coOccurCount = 0;
        int x = 0;
        int y = 0;
        int xNum = this.getNonZeroNumInRow(rowA);
        int yNum = this.getNonZeroNumInRow(rowB);
        while (x < xNum && y < yNum) {
            int yCol;
            int xCol = this.getNonZeroColumnInRow(rowA, x);
            if (xCol < (yCol = this.getNonZeroColumnInRow(rowB, y))) {
                ++x;
                continue;
            }
            if (xCol == yCol) {
                ++x;
                ++y;
                ++coOccurCount;
                continue;
            }
            ++y;
        }
        return coOccurCount;
    }

    @Override
    public double cosine(int rowA, int rowB) {
        int x = 0;
        int y = 0;
        double xy = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        int xNum = this.getNonZeroNumInRow(rowA);
        int yNum = this.getNonZeroNumInRow(rowB);
        if (xNum == 0 || yNum == 0) {
            return 0.0;
        }
        double[] arrXScore = this.getNonZeroDoubleScoresInRow(rowA);
        double[] arrYScore = this.getNonZeroDoubleScoresInRow(rowB);
        int[] arrXCol = this.getNonZeroColumnsInRow(rowA);
        int[] arrYCol = this.getNonZeroColumnsInRow(rowB);
        while (x < xNum && y < yNum) {
            if (arrXCol[x] < arrYCol[y]) {
                x2 += arrXScore[x] * arrXScore[x];
                ++x;
                continue;
            }
            if (arrXCol[x] == arrYCol[y]) {
                xy += arrXScore[x] * arrYScore[y];
                x2 += arrXScore[x] * arrXScore[x];
                y2 += arrYScore[y] * arrYScore[y];
                ++x;
                ++y;
                continue;
            }
            y2 += arrYScore[y] * arrYScore[y];
            ++y;
        }
        while (y < yNum) {
            y2 += arrYScore[y] * arrYScore[y];
            ++y;
        }
        while (x < xNum) {
            x2 += arrXScore[x] * arrXScore[x];
            ++x;
        }
        return xy / (Math.sqrt(x2) * Math.sqrt(y2));
    }

    public static boolean genTranslationMatrix(IntSparseMatrix inputCooccurMatrix, DoubleSparseMatrix outputTransMatrix) {
        for (int i = 0; i < inputCooccurMatrix.rows(); ++i) {
            int[] arrColumn = inputCooccurMatrix.getNonZeroColumnsInRow(i);
            int[] arrScore = inputCooccurMatrix.getNonZeroIntScoresInRow(i);
            double rowLen = arrColumn.length;
            double rowSum = 0.0;
            int j = 0;
            while ((double)j < rowLen) {
                rowSum += (double)arrScore[j];
                ++j;
            }
            j = 0;
            while ((double)j < rowLen) {
                outputTransMatrix.add(i, arrColumn[j], (double)arrScore[j] / rowSum);
                ++j;
            }
        }
        outputTransMatrix.finalizeData(false);
        return true;
    }

    @Override
    public Matrix transpose() {
        if (!this.isFinalized()) {
            return null;
        }
        if (this.transposeMatrix == null) {
            SparseMatrix curMatrix = this.createSparseMatrix();
            for (int i = 0; i < this.rows; ++i) {
                int num = this.getNonZeroNumInRow(i);
                for (int j = 0; j < num; ++j) {
                    curMatrix.add(this.getNonZeroCellInRow(i, j).transpose());
                }
            }
            curMatrix.finalizeData();
            curMatrix.setTranspose(this);
            this.transposeMatrix = curMatrix;
        }
        return this.transposeMatrix;
    }
}

