/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractSparseMatrix;
import dragon.matrix.Cell;
import dragon.matrix.CoordinateComparator;
import dragon.matrix.IntCell;
import dragon.matrix.SparseMatrixFactory;
import dragon.util.FastBinaryReader;
import dragon.util.FileUtil;
import dragon.util.SortedArray;
import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;

public abstract class AbstractFlatSparseMatrix
extends AbstractSparseMatrix
implements Serializable {
    protected ArrayList list;
    private int[] arrRowStartPos;
    private int lastAccessedRow;
    private int lastRowStart;
    private int lastRowEnd;
    private CoordinateComparator coordinateComparator = new CoordinateComparator();

    public AbstractFlatSparseMatrix(boolean mergeMode, boolean miniMode, int cellDataLength) {
        super(mergeMode, miniMode, cellDataLength);
        this.list = new ArrayList();
    }

    protected int getRowStart(int row) {
        if (row < this.rowBase) {
            return 0;
        }
        if (!this.miniMode) {
            return this.arrRowStartPos[row - this.rowBase];
        }
        if (row != this.lastAccessedRow) {
            this.setRowRange(row);
        }
        return this.lastRowStart;
    }

    protected int getRowEnd(int row) {
        if (row < this.rowBase) {
            return 0;
        }
        if (!this.miniMode) {
            return this.arrRowStartPos[row + 1 - this.rowBase];
        }
        if (row != this.lastAccessedRow) {
            this.setRowRange(row);
        }
        return this.lastRowEnd;
    }

    @Override
    public void close() {
        this.isFinalized = false;
        if (this.list != null) {
            this.list.clear();
        }
        this.transposeMatrix = null;
        this.arrRowStartPos = null;
        this.rows = 0;
        this.rowBase = 0;
        this.columns = 0;
    }

    @Override
    public int getNonZeroNum() {
        return this.list.size();
    }

    public Cell getNonZeroCell(int index) {
        return (Cell)this.list.get(index);
    }

    @Override
    public Cell getCell(int row, int column) {
        int end;
        if (row < this.rowBase || row >= this.rows) {
            return null;
        }
        IntCell curCell = new IntCell(row, column, 0);
        int start = this.getRowStart(row);
        int pos = SortedArray.binarySearch(this.list, curCell, start, end = this.getRowEnd(row) - 1, this.coordinateComparator);
        if (pos < 0) {
            return null;
        }
        return (Cell)this.list.get(pos);
    }

    @Override
    public Cell getNonZeroCellInRow(int row, int index) {
        return (Cell)this.list.get(this.getRowStart(row) + index);
    }

    @Override
    public int getNonZeroNumInRow(int row) {
        if (row >= this.rows) {
            return 0;
        }
        return this.getRowEnd(row) - this.getRowStart(row);
    }

    @Override
    public boolean add(Cell cell) {
        if (this.isFinalized) {
            return false;
        }
        if (this.mergeMode) {
            int pos = SortedArray.binarySearch(this.list, cell, 0, this.list.size() - 1, this.coordinateComparator);
            if (pos >= 0) {
                ((Cell)this.list.get(pos)).merge(cell);
            } else {
                this.list.add(-1 * pos - 1, cell);
            }
        } else {
            this.list.add(cell);
        }
        if (cell.getColumn() >= this.columns) {
            this.columns = cell.getColumn() + 1;
        }
        return true;
    }

    @Override
    public int getNonZeroColumnInRow(int row, int index) {
        return this.getNonZeroCellInRow(row, index).getColumn();
    }

    @Override
    public int[] getNonZeroColumnsInRow(int row) {
        int num = this.getNonZeroNumInRow(row);
        int[] arrColumn = new int[num];
        for (int count = 0; count < num; ++count) {
            arrColumn[count] = this.getNonZeroCellInRow(row, count).getColumn();
        }
        return arrColumn;
    }

    public void setNonZeroDoubleScoreInRow(int row, int index, double score) {
        this.getNonZeroCellInRow(row, index).setDoubleScore(score);
    }

    public void setNonZeroIntScoreInRow(int row, int index, int score) {
        this.getNonZeroCellInRow(row, index).setIntScore(score);
    }

    public void setDouble(int row, int column, double score) {
        Cell curCell = this.getCell(row, column);
        if (curCell != null) {
            curCell.setDoubleScore(score);
        }
    }

    public void setInt(int row, int column, int score) {
        Cell curCell = this.getCell(row, column);
        if (curCell != null) {
            curCell.setDoubleScore(score);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public boolean finalizeData(boolean sorting) {
        if (this.isFinalized) {
            return false;
        }
        if (this.mergeMode) {
            sorting = false;
        }
        if (this.list.size() > 0) {
            if (sorting) {
                Collections.sort(this.list, new CoordinateComparator());
            }
            this.rowBase = ((Cell)this.list.get(0)).getRow();
            this.rows = ((Cell)this.list.get(this.list.size() - 1)).getRow() + 1;
        } else {
            this.rowBase = 0;
            this.rows = 0;
        }
        this.isFinalized = true;
        if (!this.miniMode) {
            this.setRowStart();
        } else {
            this.setRowRange(0);
        }
        return true;
    }

    private void setRowStart() {
        int total = this.rows - this.rowBase;
        this.arrRowStartPos = new int[total + 1];
        int high = this.list.size() - 1;
        this.arrRowStartPos[0] = 0;
        this.arrRowStartPos[total] = this.list.size();
        for (int i = 1; i < total; ++i) {
            IntCell curCell = new IntCell(i + this.rowBase, 0);
            int pos = SortedArray.binarySearch(this.list, curCell, this.arrRowStartPos[i - 1], high);
            if (pos < 0) {
                pos = -1 * pos - 1;
            }
            this.arrRowStartPos[i] = pos;
        }
    }

    public void saveTo(String filename, boolean binary) {
        if (!binary) {
            this.saveTo(filename);
        } else {
            SparseMatrixFactory factory = new SparseMatrixFactory(filename, this.getCellDataLength());
            factory.add(this);
        }
    }

    public void saveTo(String filename) {
        this.print(FileUtil.getPrintWriter(filename));
    }

    public void print(PrintWriter out) {
        try {
            out.write(String.valueOf(this.rows) + "," + String.valueOf(this.columns) + "," + String.valueOf(this.list.size()) + "\n");
            for (int i = 0; i < this.rows; ++i) {
                int num = this.getNonZeroNumInRow(i);
                for (int j = 0; j < num; ++j) {
                    Cell cur = this.getNonZeroCellInRow(i, j);
                    out.write("(" + i + "," + cur.getColumn() + "," + cur.toString() + ")\t");
                }
                out.write("\n");
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean readBinaryMatrixFile(String filename) {
        this.isFinalized = false;
        byte[] data = new byte[this.getCellDataLength()];
        try {
            FastBinaryReader rafMatrix = new FastBinaryReader(filename);
            int rows = rafMatrix.readInt();
            this.columns = rafMatrix.readInt();
            int cells = rafMatrix.readInt();
            this.list = new ArrayList(cells);
            for (int i = 0; i < rows; ++i) {
                int row = i;
                rafMatrix.readInt();
                int num = rafMatrix.readInt();
                for (int j = 0; j < num; ++j) {
                    int column = rafMatrix.readInt();
                    rafMatrix.read(data);
                    this.add(this.createCell(row, column, data));
                }
            }
            rafMatrix.close();
            this.finalizeData(false);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected boolean readTextMatrixFile(String filename) {
        this.isFinalized = false;
        try {
            BufferedReader br = FileUtil.getTextReader(filename);
            String fragment = br.readLine();
            int i = 0;
            int j = fragment.indexOf(44, i);
            this.rows = Integer.parseInt(fragment.substring(i, j));
            i = j + 1;
            j = fragment.indexOf(44, i);
            this.columns = Integer.parseInt(fragment.substring(i, j));
            int cells = Integer.parseInt(fragment.substring(j + 1));
            this.list = new ArrayList(cells);
            int lineNo = -1;
            String line = br.readLine();
            while (line != null) {
                this.processLine(++lineNo, line);
                line = br.readLine();
            }
            br.close();
            this.finalizeData(false);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void processLine(int lineNo, String line) {
        int startPos = 0;
        int endPos = line.indexOf(9, startPos);
        while (endPos > 0) {
            String fragment = line.substring(startPos, endPos);
            startPos = endPos + 1;
            endPos = line.indexOf(9, startPos);
            int i = fragment.indexOf(40) + 1;
            int j = fragment.indexOf(44, i);
            int row = Integer.parseInt(fragment.substring(i, j));
            i = j + 1;
            j = fragment.indexOf(44, i);
            int col = Integer.parseInt(fragment.substring(i, j));
            i = j + 1;
            j = fragment.indexOf(41, i);
            Cell cur = this.createCell(row, col, fragment.substring(i, j));
            this.add(cur);
        }
    }

    private void setRowRange(int row) {
        this.lastAccessedRow = row;
        this.lastRowStart = SortedArray.binarySearch(this.list, new IntCell(row, 0), 0, this.list.size() - 1, this.coordinateComparator);
        if (this.lastRowStart < 0) {
            this.lastRowStart = this.lastRowStart * -1 - 1;
        }
        this.lastRowEnd = SortedArray.binarySearch(this.list, new IntCell(row + 1, 0), this.lastRowStart, this.list.size() - 1, this.coordinateComparator);
        if (this.lastRowEnd < 0) {
            this.lastRowEnd = this.lastRowEnd * -1 - 1;
        }
    }
}

