/*
 * Decompiled with CFR 0.152.
 */
package dragon.matrix;

import dragon.matrix.AbstractMatrix;
import dragon.matrix.DenseMatrix;
import java.io.Serializable;

public abstract class AbstractDenseMatrix
extends AbstractMatrix
implements DenseMatrix,
Serializable {
    public AbstractDenseMatrix(int row, int column, int cellDataLength) {
        this.rows = row;
        this.columns = column;
        this.cellDataLength = cellDataLength;
    }

    @Override
    public double cosine(int rowA, int rowB) {
        int productSum = 0;
        int vLenA = 0;
        int vLenB = 0;
        for (int i = 0; i < this.columns; ++i) {
            if (this.cellDataLength == 8) {
                productSum = (int)((double)productSum + this.getDouble(rowA, i) * this.getDouble(rowB, i));
                vLenA = (int)((double)vLenA + this.getDouble(rowA, i) * this.getDouble(rowA, i));
                vLenB = (int)((double)vLenB + this.getDouble(rowB, i) * this.getDouble(rowB, i));
                continue;
            }
            productSum += this.getInt(rowA, i) * this.getInt(rowB, i);
            vLenA += this.getInt(rowA, i) * this.getInt(rowA, i);
            vLenB += this.getInt(rowB, i) * this.getInt(rowB, i);
        }
        return (double)productSum / Math.sqrt(vLenA) * Math.sqrt(vLenB);
    }

    @Override
    public int getCooccurrenceCount(int rowA, int rowB) {
        int coOccurCount = 0;
        for (int i = 0; i < this.columns; ++i) {
            if (this.cellDataLength != 8) continue;
            if (this.getDouble(rowA, i) != 0.0 && this.getDouble(rowB, i) != 0.0) {
                ++coOccurCount;
                continue;
            }
            if (this.getInt(rowA, i) == 0 || this.getInt(rowB, i) == 0) continue;
            ++coOccurCount;
        }
        return coOccurCount;
    }
}

