/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.topicmodel;

import dragon.ir.index.IndexReader;
import dragon.ir.topicmodel.AbstractTwoDimensionModel;
import dragon.matrix.vector.DoubleVector;
import java.util.Random;

public class TwoDimensionEM
extends AbstractTwoDimensionModel {
    protected DoubleVector viewBkgModel;
    protected DoubleVector themeBkgModel;
    protected double viewBkgCoeffi;
    protected double themeBkgCoeffi;
    protected double comThemeCoeffi;

    public TwoDimensionEM(IndexReader viewIndexReader, IndexReader topicIndexReader, double viewBkgCoeffi, double themeBkgCoeffi, double comThemeCoeffi) {
        this(viewIndexReader, null, viewBkgCoeffi, topicIndexReader, null, themeBkgCoeffi, comThemeCoeffi);
    }

    public TwoDimensionEM(IndexReader viewIndexReader, DoubleVector viewBkgModel, double viewBkgCoeffi, IndexReader topicIndexReader, DoubleVector themeBkgModel, double themeBkgCoeffi, double comThemeCoeffi) {
        super(viewIndexReader, topicIndexReader);
        viewBkgModel = viewBkgModel == null ? this.getBkgModel(viewIndexReader) : viewBkgModel.copy();
        this.viewBkgCoeffi = viewBkgCoeffi;
        this.viewBkgModel.multiply(viewBkgCoeffi);
        themeBkgModel = themeBkgModel == null ? this.getBkgModel(topicIndexReader) : themeBkgModel.copy();
        this.themeBkgCoeffi = themeBkgCoeffi;
        this.themeBkgModel.multiply(themeBkgCoeffi);
        this.comThemeCoeffi = comThemeCoeffi;
    }

    @Override
    public boolean estimateModel(int viewNum, int topicNum) {
        this.viewNum = viewNum;
        this.themeNum = topicNum;
        this.arrViewProb = new double[viewNum][this.viewTermNum];
        double[][] arrTempViewProb = new double[viewNum][this.viewTermNum];
        this.arrDocView = new double[this.docNum][viewNum];
        double[] arrDocViewSum = new double[viewNum];
        double[] arrViewProbSum = new double[viewNum];
        this.arrThemeProb = new double[viewNum][this.themeNum][this.themeTermNum];
        double[][][] arrTempThemeProb = new double[viewNum][this.themeNum][this.themeTermNum];
        this.arrCommonThemeProb = new double[this.themeNum][this.themeTermNum];
        double[][] arrTempThemeCommonProb = new double[this.themeNum][this.themeTermNum];
        this.arrDocTheme = new double[this.docNum][viewNum][this.themeNum];
        double[][] arrDocThemeSum = new double[viewNum][this.themeNum];
        this.initialize(this.docNum, this.viewTermNum, viewNum, this.arrViewProb, this.arrDocView, this.themeTermNum, this.themeNum, this.arrCommonThemeProb, this.arrThemeProb, this.arrDocTheme);
        this.printStatus("Estimating the coefficients of two-dimensional mixture model...");
        for (int k = 0; k < this.iterations; ++k) {
            double termProbSum;
            int l;
            int i;
            int m;
            this.printStatus("Iteration #" + (k + 1));
            for (m = 0; m < viewNum; ++m) {
                for (i = 0; i < this.viewTermNum; ++i) {
                    arrTempViewProb[m][i] = 0.0;
                }
            }
            for (l = 0; l < this.themeNum; ++l) {
                for (i = 0; i < this.themeTermNum; ++i) {
                    arrTempThemeCommonProb[l][i] = 0.0;
                }
            }
            for (m = 0; m < viewNum; ++m) {
                for (l = 0; l < this.themeNum; ++l) {
                    for (i = 0; i < this.themeTermNum; ++i) {
                        arrTempThemeProb[m][l][i] = 0.0;
                    }
                }
            }
            for (i = 0; i < this.docNum; ++i) {
                double docWeightSum;
                double termProb;
                double themeProb;
                double themeProbSum;
                int termIndex;
                int j;
                for (m = 0; m < viewNum; ++m) {
                    arrDocViewSum[m] = 0.0;
                }
                for (m = 0; m < viewNum; ++m) {
                    for (l = 0; l < this.themeNum; ++l) {
                        arrDocThemeSum[m][l] = 0.0;
                    }
                }
                int[] arrIndex = this.topicIndexReader.getTermIndexList(i);
                int[] arrFreq = this.topicIndexReader.getTermFrequencyList(i);
                for (j = 0; j < arrIndex.length; ++j) {
                    termIndex = arrIndex[j];
                    themeProbSum = 0.0;
                    for (m = 0; m < viewNum; ++m) {
                        arrViewProbSum[m] = 0.0;
                        for (l = 0; l < this.themeNum; ++l) {
                            int n = m;
                            arrViewProbSum[n] = arrViewProbSum[n] + ((1.0 - this.comThemeCoeffi) * this.arrThemeProb[m][l][termIndex] + this.comThemeCoeffi * this.arrCommonThemeProb[l][termIndex]) * this.arrDocTheme[i][m][l];
                        }
                        arrViewProbSum[m] = arrViewProbSum[m] * this.arrDocView[i][m];
                        themeProbSum += arrViewProbSum[m];
                    }
                    double themeBkgProb = themeProbSum != 0.0 ? this.themeBkgModel.get(termIndex) / (themeProbSum * (1.0 - this.themeBkgCoeffi) + this.themeBkgModel.get(termIndex)) : 0.0;
                    for (m = 0; m < viewNum; ++m) {
                        if (themeProbSum != 0.0) {
                            int n = m;
                            arrDocViewSum[n] = arrDocViewSum[n] + (double)arrFreq[j] * arrViewProbSum[m] / themeProbSum;
                        }
                        for (l = 0; l < this.themeNum; ++l) {
                            themeProb = themeProbSum != 0.0 ? ((1.0 - this.comThemeCoeffi) * this.arrThemeProb[m][l][termIndex] + this.comThemeCoeffi * this.arrCommonThemeProb[l][termIndex]) * this.arrDocView[i][m] * this.arrDocTheme[i][m][l] / themeProbSum : 0.0;
                            double commonThemeProb = (1.0 - this.comThemeCoeffi) * this.arrThemeProb[m][l][termIndex] + this.comThemeCoeffi * this.arrCommonThemeProb[l][termIndex];
                            commonThemeProb = commonThemeProb > 0.0 ? this.comThemeCoeffi * this.arrCommonThemeProb[l][termIndex] / commonThemeProb : 0.0;
                            termProb = (double)arrFreq[j] * themeProb;
                            double[] dArray = arrDocThemeSum[m];
                            int n = l;
                            dArray[n] = dArray[n] + termProb;
                            double[] dArray2 = arrTempThemeProb[m][l];
                            int n2 = termIndex;
                            dArray2[n2] = dArray2[n2] + (termProb *= 1.0 - themeBkgProb) * (1.0 - commonThemeProb);
                            double[] dArray3 = arrTempThemeCommonProb[l];
                            int n3 = termIndex;
                            dArray3[n3] = dArray3[n3] + termProb * commonThemeProb;
                        }
                    }
                }
                for (m = 0; m < viewNum; ++m) {
                    docWeightSum = 0.0;
                    for (l = 0; l < this.themeNum; ++l) {
                        docWeightSum += arrDocThemeSum[m][l];
                    }
                    if (docWeightSum > 0.0) {
                        for (l = 0; l < this.themeNum; ++l) {
                            this.arrDocTheme[i][m][l] = arrDocThemeSum[m][l] / docWeightSum;
                        }
                        continue;
                    }
                    for (l = 0; l < this.themeNum; ++l) {
                        this.arrDocTheme[i][m][l] = 0.0;
                    }
                }
                arrIndex = this.viewIndexReader.getTermIndexList(i);
                arrFreq = this.viewIndexReader.getTermFrequencyList(i);
                for (j = 0; j < arrIndex.length; ++j) {
                    termIndex = arrIndex[j];
                    themeProbSum = 0.0;
                    for (m = 0; m < viewNum; ++m) {
                        themeProbSum += this.arrViewProb[m][termIndex] * this.arrDocView[m][i];
                    }
                    double viewBkgProb = this.viewBkgModel.get(termIndex) / (themeProbSum * (1.0 - this.viewBkgCoeffi) + this.viewBkgModel.get(termIndex));
                    for (m = 0; m < viewNum; ++m) {
                        themeProb = themeProbSum != 0.0 ? this.arrViewProb[m][termIndex] * this.arrDocView[i][m] / themeProbSum : 0.0;
                        termProb = (double)arrFreq[j] * themeProb;
                        int n = m;
                        arrDocViewSum[n] = arrDocViewSum[n] + termProb;
                        double[] dArray = arrTempViewProb[m];
                        int n4 = termIndex;
                        dArray[n4] = dArray[n4] + (termProb *= 1.0 - viewBkgProb);
                    }
                }
                docWeightSum = 0.0;
                for (m = 0; m < viewNum; ++m) {
                    docWeightSum += arrDocViewSum[m];
                }
                if (docWeightSum > 0.0) {
                    for (m = 0; m < viewNum; ++m) {
                        this.arrDocView[i][m] = arrDocViewSum[m] / docWeightSum;
                    }
                    continue;
                }
                for (m = 0; m < viewNum; ++m) {
                    this.arrDocView[i][m] = 0.0;
                }
            }
            for (m = 0; m < viewNum; ++m) {
                termProbSum = 0.0;
                for (i = 0; i < this.viewTermNum; ++i) {
                    termProbSum += arrTempViewProb[m][i];
                }
                for (i = 0; i < this.viewTermNum; ++i) {
                    this.arrViewProb[m][i] = termProbSum != 0.0 ? arrTempViewProb[m][i] / termProbSum : 0.0;
                }
            }
            for (l = 0; l < this.themeNum; ++l) {
                termProbSum = 0.0;
                for (i = 0; i < this.themeTermNum; ++i) {
                    termProbSum += arrTempThemeCommonProb[l][i];
                }
                for (i = 0; i < this.themeTermNum; ++i) {
                    if (termProbSum != 0.0) {
                        this.arrCommonThemeProb[l][i] = arrTempThemeCommonProb[l][i] / termProbSum;
                        continue;
                    }
                    this.arrCommonThemeProb[1][i] = 0.0;
                }
            }
            for (m = 0; m < viewNum; ++m) {
                for (l = 0; l < this.themeNum; ++l) {
                    termProbSum = 0.0;
                    for (i = 0; i < this.themeTermNum; ++i) {
                        termProbSum += arrTempThemeProb[m][l][i];
                    }
                    for (i = 0; i < this.themeTermNum; ++i) {
                        if (termProbSum != 0.0) {
                            this.arrThemeProb[m][l][i] = arrTempThemeProb[m][l][i] / termProbSum;
                            continue;
                        }
                        this.arrThemeProb[m][1][i] = 0.0;
                    }
                }
            }
        }
        this.printStatus("");
        return true;
    }

    protected void initialize(int docNum, int viewTermNum, int viewNum, double[][] arrViewModel, double[][] arrDocView, int themeTermNum, int themeNum, double[][] arrThemeCommonModel, double[][][] arrThemeModel, double[][][] arrDocTheme) {
        int k;
        double docProb;
        int j;
        int i;
        Random random = this.seed >= 0 ? new Random(this.seed) : new Random();
        double termProb = 1.0 / (double)viewTermNum;
        for (i = 0; i < viewNum; ++i) {
            for (j = 0; j < viewTermNum; ++j) {
                arrViewModel[i][j] = termProb;
            }
        }
        for (i = 0; i < docNum; ++i) {
            docProb = 0.0;
            for (j = 0; j < viewNum; ++j) {
                arrDocView[i][j] = random.nextDouble();
                docProb += arrDocView[i][j];
            }
            for (j = 0; j < viewNum; ++j) {
                arrDocView[i][j] = arrDocView[i][j] / docProb;
            }
        }
        termProb = 1.0 / (double)themeTermNum;
        for (j = 0; j < themeNum; ++j) {
            for (k = 0; k < themeTermNum; ++k) {
                arrThemeCommonModel[j][k] = termProb;
            }
        }
        for (i = 0; i < viewNum; ++i) {
            for (j = 0; j < themeNum; ++j) {
                for (k = 0; k < themeTermNum; ++k) {
                    arrThemeModel[i][j][k] = termProb;
                }
            }
        }
        for (i = 0; i < viewNum; ++i) {
            for (k = 0; k < docNum; ++k) {
                docProb = 0.0;
                for (j = 0; j < themeNum; ++j) {
                    arrDocTheme[k][i][j] = random.nextDouble();
                    docProb += arrDocTheme[k][i][j];
                }
                for (j = 0; j < themeNum; ++j) {
                    arrDocTheme[k][i][j] = docProb != 0.0 ? arrDocTheme[k][i][j] / docProb : 0.0;
                }
            }
        }
    }
}

