/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.topicmodel;

import dragon.ir.index.IndexReader;
import dragon.ir.index.sequence.SequenceIndexReader;
import dragon.ir.topicmodel.AbstractTopicModel;
import java.util.Date;
import java.util.Random;

public class GibbsLDA
extends AbstractTopicModel {
    private int indexType;
    private int tokenNum;
    private double alpha;
    private double beta;
    private double wBeta;
    private double tAlpha;

    public GibbsLDA(SequenceIndexReader indexReader, double alpha, double beta) {
        this(indexReader, alpha, beta, 1);
    }

    public GibbsLDA(IndexReader indexReader, double alpha, double beta) {
        this(indexReader, alpha, beta, 0);
    }

    private GibbsLDA(IndexReader indexReader, double alpha, double beta, int indexType) {
        super(indexReader);
        this.alpha = alpha;
        this.beta = beta;
        this.iterations = 500;
        this.termNum = indexReader.getCollection().getTermNum();
        this.tokenNum = (int)indexReader.getCollection().getTermCount();
        this.docNum = indexReader.getCollection().getDocNum();
        this.wBeta = (double)this.termNum * beta;
        this.indexType = indexType;
    }

    @Override
    public boolean estimateModel(int topicNum) {
        int j;
        int i;
        this.themeNum = topicNum;
        this.tAlpha = (double)this.themeNum * this.alpha;
        int[][] arrTTCount = new int[this.termNum][this.themeNum];
        int[][] arrDTCount = new int[this.docNum][this.themeNum];
        int[] arrTerm = new int[this.tokenNum];
        int[] arrDoc = new int[this.tokenNum];
        int[] arrTermLabel = new int[this.tokenNum];
        this.printStatus(new Date().toString() + " Reading sequence...");
        if (this.indexType == 0) {
            this.readSequence(this.indexReader, arrTerm, arrDoc);
        } else {
            this.readSequence((SequenceIndexReader)this.indexReader, arrTerm, arrDoc);
        }
        this.run(this.seed, arrTerm, arrDoc, arrTermLabel, arrTTCount, arrDTCount);
        this.arrThemeTerm = new double[this.themeNum][this.termNum];
        for (i = 0; i < this.themeNum; ++i) {
            double topicSum = this.wBeta;
            for (j = 0; j < this.termNum; ++j) {
                topicSum += (double)arrTTCount[j][i];
            }
            for (j = 0; j < this.termNum; ++j) {
                this.arrThemeTerm[i][j] = ((double)arrTTCount[j][i] + this.beta) / topicSum;
            }
        }
        this.arrDocTheme = new double[this.docNum][this.themeNum];
        for (i = 0; i < this.docNum; ++i) {
            double docSum = this.tAlpha;
            for (j = 0; j < this.themeNum; ++j) {
                docSum += (double)arrDTCount[i][j];
            }
            for (j = 0; j < this.themeNum; ++j) {
                this.arrDocTheme[i][j] = ((double)arrDTCount[i][j] + this.alpha) / docSum;
            }
        }
        return true;
    }

    private void run(int seed, int[] arrTerm, int[] arrDoc, int[] arrTermLabel, int[][] arrTTCount, int[][] arrDTCount) {
        int k;
        int docIndex;
        int termIndex;
        int topic;
        int i;
        int[] arrTopicCount = new int[this.themeNum];
        int[] arrOrder = new int[this.tokenNum];
        Random random = new Random();
        if (seed >= 0) {
            random.setSeed(seed);
        }
        this.printStatus(new Date().toString() + " Starting random initialization...");
        for (i = 0; i < this.tokenNum; ++i) {
            arrTermLabel[i] = topic = random.nextInt(this.themeNum);
            termIndex = arrTerm[i];
            docIndex = arrDoc[i];
            int[] nArray = arrTTCount[termIndex];
            int n = topic;
            nArray[n] = nArray[n] + 1;
            int[] nArray2 = arrDTCount[docIndex];
            int n2 = topic;
            nArray2[n2] = nArray2[n2] + 1;
            int n3 = topic;
            arrTopicCount[n3] = arrTopicCount[n3] + 1;
        }
        this.printStatus(new Date().toString() + " Determining random update sequence...");
        for (i = 0; i < this.tokenNum; ++i) {
            arrOrder[i] = i;
        }
        for (i = 0; i < this.tokenNum - 1; ++i) {
            k = i + random.nextInt(this.tokenNum - i);
            int j = arrOrder[k];
            arrOrder[k] = arrOrder[i];
            arrOrder[i] = j;
        }
        for (int iter = 0; iter < this.iterations; ++iter) {
            this.printStatus(new Date().toString() + " Iteration #" + (iter + 1));
            for (k = 0; k < this.tokenNum; ++k) {
                i = arrOrder[k];
                termIndex = arrTerm[i];
                docIndex = arrDoc[i];
                int n = topic = arrTermLabel[i];
                arrTopicCount[n] = arrTopicCount[n] - 1;
                int[] nArray = arrTTCount[termIndex];
                int n4 = topic;
                nArray[n4] = nArray[n4] - 1;
                int[] nArray3 = arrDTCount[docIndex];
                int n5 = topic;
                nArray3[n5] = nArray3[n5] - 1;
                arrTermLabel[i] = topic = this.sampleTopic(random, arrTTCount[termIndex], arrDTCount[docIndex], arrTopicCount);
                int[] nArray4 = arrTTCount[termIndex];
                int n6 = topic;
                nArray4[n6] = nArray4[n6] + 1;
                int[] nArray5 = arrDTCount[docIndex];
                int n7 = topic;
                nArray5[n7] = nArray5[n7] + 1;
                int n8 = topic;
                arrTopicCount[n8] = arrTopicCount[n8] + 1;
            }
        }
    }

    private int sampleTopic(Random random, int[] arrTTCount, int[] arrDTCount, int[] arrTopicCount) {
        double totalProb = 0.0;
        double[] arrProb = new double[this.themeNum];
        for (int j = 0; j < this.themeNum; ++j) {
            arrProb[j] = ((double)arrTTCount[j] + this.beta) / ((double)arrTopicCount[j] + this.wBeta) * ((double)arrDTCount[j] + this.alpha);
            totalProb += arrProb[j];
        }
        double r = totalProb * random.nextDouble();
        int topic = 0;
        for (double max = arrProb[0]; r > max; max += arrProb[++topic]) {
        }
        return topic;
    }

    private void readSequence(SequenceIndexReader indexReader, int[] arrTerm, int[] arrDoc) {
        int docNum = indexReader.getCollection().getDocNum();
        int count = 0;
        for (int i = 0; i < docNum; ++i) {
            int[] arrSeq = indexReader.getTermIndexList(i);
            if (arrSeq == null || arrSeq.length == 0) continue;
            for (int j = 0; j < arrSeq.length; ++j) {
                arrTerm[count + j] = arrSeq[j];
                arrDoc[count + j] = i;
            }
            count += arrSeq.length;
        }
    }

    private void readSequence(IndexReader indexReader, int[] arrTerm, int[] arrDoc) {
        int docNum = indexReader.getCollection().getDocNum();
        int count = 0;
        for (int i = 0; i < docNum; ++i) {
            int[] arrIndex = indexReader.getTermIndexList(i);
            int[] arrFreq = indexReader.getTermFrequencyList(i);
            if (arrIndex == null || arrIndex.length == 0) continue;
            for (int j = 0; j < arrIndex.length; ++j) {
                for (int k = 0; k < arrFreq[j]; ++k) {
                    arrTerm[count + k] = arrIndex[j];
                    arrDoc[count + k] = i;
                }
                count += arrFreq[j];
            }
        }
    }
}

