/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.topicmodel;

import dragon.ir.index.IndexReader;
import dragon.ir.topicmodel.AbstractTopicModel;
import java.util.Date;
import java.util.Random;

public class AspectModel
extends AbstractTopicModel {
    public AspectModel(IndexReader indexReader) {
        super(indexReader);
    }

    @Override
    public boolean estimateModel(int topicNum) {
        return this.estimateModel(null, topicNum);
    }

    public boolean estimateModel(int[] arrDoc, int topicNum) {
        this.themeNum = topicNum;
        this.termNum = this.indexReader.getCollection().getTermNum();
        this.docNum = arrDoc == null ? this.indexReader.getCollection().getDocNum() : arrDoc.length;
        this.arrThemeTerm = new double[this.themeNum][this.termNum];
        double[][] arrTempProb = new double[this.themeNum][this.termNum];
        this.arrDocTheme = new double[this.docNum][this.themeNum];
        double[] arrDocWeightSum = new double[this.themeNum];
        this.initialize(this.termNum, this.themeNum, this.docNum, this.arrThemeTerm, this.arrDocTheme);
        this.printStatus("Estimating the coefficients of simple mixture model...");
        for (int k = 0; k < this.iterations; ++k) {
            int j;
            int i;
            this.printStatus(new Date().toString() + " Iteration #" + (k + 1));
            for (i = 0; i < this.themeNum; ++i) {
                for (j = 0; j < this.termNum; ++j) {
                    arrTempProb[i][j] = 0.0;
                }
            }
            for (i = 0; i < this.docNum; ++i) {
                int m;
                int[] arrFreq;
                int[] arrIndex;
                if (arrDoc == null) {
                    arrIndex = this.indexReader.getTermIndexList(i);
                    arrFreq = this.indexReader.getTermFrequencyList(i);
                } else {
                    arrIndex = this.indexReader.getTermIndexList(arrDoc[i]);
                    arrFreq = this.indexReader.getTermFrequencyList(arrDoc[i]);
                }
                for (m = 0; m < this.themeNum; ++m) {
                    arrDocWeightSum[m] = 0.0;
                }
                for (j = 0; j < arrIndex.length; ++j) {
                    int termIndex = arrIndex[j];
                    double themeProbSum = 0.0;
                    for (m = 0; m < this.themeNum; ++m) {
                        themeProbSum += this.arrThemeTerm[m][termIndex] * this.arrDocTheme[i][m];
                    }
                    for (m = 0; m < this.themeNum; ++m) {
                        double themeProb = themeProbSum != 0.0 ? this.arrThemeTerm[m][termIndex] * this.arrDocTheme[i][m] / themeProbSum : 0.0;
                        double termProb = (double)arrFreq[j] * themeProb;
                        int n = m;
                        arrDocWeightSum[n] = arrDocWeightSum[n] + termProb;
                        double[] dArray = arrTempProb[m];
                        int n2 = termIndex;
                        dArray[n2] = dArray[n2] + termProb;
                    }
                }
                double docWeightSum = 0.0;
                for (m = 0; m < this.themeNum; ++m) {
                    docWeightSum += arrDocWeightSum[m];
                }
                if (docWeightSum > 0.0) {
                    for (m = 0; m < this.themeNum; ++m) {
                        this.arrDocTheme[i][m] = arrDocWeightSum[m] / docWeightSum;
                    }
                    continue;
                }
                for (m = 0; m < this.themeNum; ++m) {
                    this.arrDocTheme[i][m] = 0.0;
                }
            }
            for (i = 0; i < this.themeNum; ++i) {
                double termProbSum = 0.0;
                for (j = 0; j < this.termNum; ++j) {
                    termProbSum += arrTempProb[i][j];
                }
                for (j = 0; j < this.termNum; ++j) {
                    this.arrThemeTerm[i][j] = arrTempProb[i][j] / termProbSum;
                }
            }
        }
        this.printStatus("");
        return true;
    }

    protected void initialize(int termNum, int themeNum, int docNum, double[][] arrModel, double[][] arrDocMembership) {
        int j;
        int i;
        double termProb = 1.0 / (double)termNum;
        for (i = 0; i < themeNum; ++i) {
            for (j = 0; j < termNum; ++j) {
                arrModel[i][j] = termProb;
            }
        }
        Random random = new Random(this.seed);
        for (i = 0; i < docNum; ++i) {
            double docProb = 0.0;
            for (j = 0; j < themeNum; ++j) {
                arrDocMembership[i][j] = random.nextDouble();
                docProb += arrDocMembership[i][j];
            }
            for (j = 0; j < themeNum; ++j) {
                arrDocMembership[i][j] = arrDocMembership[i][j] / docProb;
            }
        }
    }
}

