/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.topicmodel;

import dragon.ir.index.IndexReader;
import dragon.ir.topicmodel.AbstractModel;
import dragon.ir.topicmodel.TwoDimensionModel;

public abstract class AbstractTwoDimensionModel
extends AbstractModel
implements TwoDimensionModel {
    protected IndexReader viewIndexReader;
    protected IndexReader topicIndexReader;
    protected int docNum;
    protected int viewNum;
    protected int themeNum;
    protected int viewTermNum;
    protected int themeTermNum;
    protected double[][] arrViewProb;
    protected double[][] arrDocView;
    protected double[][][] arrThemeProb;
    protected double[][][] arrDocTheme;
    protected double[][] arrCommonThemeProb;

    public AbstractTwoDimensionModel(IndexReader viewIndexReader, IndexReader topicIndexReader) {
        this.viewIndexReader = viewIndexReader;
        this.topicIndexReader = topicIndexReader;
        this.docNum = Math.min(viewIndexReader.getCollection().getDocNum(), topicIndexReader.getCollection().getDocNum());
        this.viewTermNum = viewIndexReader.getCollection().getTermNum();
        this.themeTermNum = topicIndexReader.getCollection().getTermNum();
    }

    @Override
    public int getViewNum() {
        return this.viewNum;
    }

    @Override
    public int getTopicNum() {
        return this.themeNum;
    }

    @Override
    public double[] getView(int viewIndex) {
        return this.arrViewProb[viewIndex];
    }

    @Override
    public double[] getCommonTopic(int topicIndex) {
        return this.arrCommonThemeProb[topicIndex];
    }

    @Override
    public double[] getViewTopic(int viewIndex, int topicIndex) {
        return this.arrThemeProb[viewIndex][topicIndex];
    }

    @Override
    public int getDocNum() {
        return this.docNum;
    }

    @Override
    public double[] getDocViews(int docIndex) {
        return this.arrDocView[docIndex];
    }

    @Override
    public double[] getDocTopics(int docIndex, int viewIndex) {
        return this.arrDocTheme[docIndex][viewIndex];
    }

    @Override
    public int getViewTermNum() {
        return this.viewTermNum;
    }

    @Override
    public int getTopicTermNum() {
        return this.themeTermNum;
    }

    @Override
    public String getViewTermName(int termIndex) {
        return this.viewIndexReader.getTermKey(termIndex);
    }

    @Override
    public String getTopicTermName(int termIndex) {
        return this.topicIndexReader.getTermKey(termIndex);
    }
}

