/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.topicmodel;

import dragon.ir.index.IndexReader;
import dragon.matrix.vector.DoubleVector;
import java.io.PrintWriter;

public class AbstractModel {
    protected int iterations = 100;
    protected int seed = -1;
    protected PrintWriter statusOut;

    public int getIterationNum() {
        return this.iterations;
    }

    public void setIterationNum(int num) {
        this.iterations = num;
    }

    public void setRandomSeed(int seed) {
        this.seed = seed;
    }

    public void setStatusOut(PrintWriter out) {
        this.statusOut = out;
    }

    protected void printStatus(String line) {
        try {
            System.out.println(line);
            if (this.statusOut != null) {
                this.statusOut.write(line + "\n");
                this.statusOut.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected DoubleVector getBkgModel(IndexReader indexReader) {
        DoubleVector bkgModel = new DoubleVector(indexReader.getCollection().getTermNum());
        for (int i = 0; i < bkgModel.size(); ++i) {
            bkgModel.set(i, indexReader.getIRTerm(i).getFrequency());
        }
        bkgModel.multiply(1.0 / (double)indexReader.getCollection().getTermCount());
        return bkgModel;
    }
}

