/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.summarize;

import dragon.ir.clustering.docdistance.KLDivDocDistance;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.ir.index.sentence.OnlineSentenceIndexReader;
import dragon.ir.index.sentence.OnlineSentenceIndexer;
import dragon.ir.kngbase.DocRepresentation;
import dragon.ir.kngbase.KnowledgeBase;
import dragon.ir.summarize.LexRankSummarizer;
import dragon.matrix.DoubleSparseMatrix;
import dragon.nlp.SimpleElementList;

public class SemanticRankSummarizer
extends LexRankSummarizer {
    private OnlineSentenceIndexer phraseIndexer;
    private KnowledgeBase kngBase;
    private double transCoefficient;
    private double bkgCoefficient;
    private double maxKLDivDistance;

    public SemanticRankSummarizer(OnlineSentenceIndexer tokenIndexer, KnowledgeBase kngBase) {
        this(tokenIndexer, null, kngBase);
    }

    public SemanticRankSummarizer(OnlineSentenceIndexer tokenIndexer, OnlineSentenceIndexer phraseIndexer, KnowledgeBase kngBase) {
        super(tokenIndexer);
        this.phraseIndexer = phraseIndexer;
        if (phraseIndexer != null) {
            phraseIndexer.setMinSentenceLength(tokenIndexer.getMinSentenceLength());
        }
        this.kngBase = kngBase;
        this.transCoefficient = 0.3;
        this.bkgCoefficient = 0.4;
        this.maxKLDivDistance = 10.0;
    }

    public void setTranslationCoefficient(double coefficient) {
        this.transCoefficient = coefficient;
    }

    public void setBackgroundCoefficient(double coefficient) {
        this.bkgCoefficient = coefficient;
    }

    public void setMaxKLDivDistance(double distance) {
        this.maxKLDivDistance = distance;
    }

    private DoubleSparseMatrix computeTransDocTermMatrix() {
        DoubleSparseMatrix transMatrix;
        if (this.phraseIndexer != null) {
            this.collectionReader.restart();
            OnlineSentenceIndexReader phraseIndexReader = new OnlineSentenceIndexReader(this.phraseIndexer, this.collectionReader);
            phraseIndexReader.initialize();
            int[] phraseMap = this.getTermMap(phraseIndexReader, this.kngBase.getRowKeyList());
            int[] termMap = this.getTermMap(this.indexReader, this.kngBase.getColumnKeyList());
            DocRepresentation docRep = new DocRepresentation(this.indexReader, termMap);
            transMatrix = docRep.genModelMatrix(phraseIndexReader, phraseMap, this.kngBase.getKnowledgeMatrix(), this.transCoefficient, this.bkgCoefficient, true, 0.001);
            phraseIndexReader.close();
        } else {
            int[] termMap = this.getTermMap(this.indexReader, this.kngBase.getColumnKeyList());
            DocRepresentation docRep = new DocRepresentation(this.indexReader, termMap);
            transMatrix = docRep.genModelMatrix(this.indexReader, termMap, this.kngBase.getKnowledgeMatrix(), this.transCoefficient, this.bkgCoefficient, true, 0.001);
        }
        return transMatrix;
    }

    private int[] getTermMap(IndexReader reader, SimpleElementList newTermList) {
        int[] termMap = new int[reader.getCollection().getTermNum()];
        int newTermNum = newTermList.size();
        for (int i = 0; i < termMap.length; ++i) {
            String curKey = reader.getTermKey(i);
            int newIndex = newTermList.search(curKey);
            termMap[i] = newIndex >= 0 ? newIndex : newTermNum++;
        }
        return termMap;
    }

    @Override
    protected double computeSimilarity(IRDoc firstSent, IRDoc secondSent) {
        if (this.distanceMetric == null) {
            this.distanceMetric = new KLDivDocDistance(this.computeTransDocTermMatrix(), this.maxKLDivDistance);
        }
        return Math.max(1.0 - this.distanceMetric.getDistance(firstSent, secondSent), 1.0 - this.distanceMetric.getDistance(secondSent, firstSent));
    }
}

