/*
 * Decompiled with CFR 0.152.
 */
package dragon.ir.summarize;

import dragon.config.ConfigureNode;
import dragon.config.IndexerConfig;
import dragon.ir.clustering.BasicKMean;
import dragon.ir.clustering.clustermodel.ClusterModel;
import dragon.ir.clustering.clustermodel.CosineClusterModel;
import dragon.ir.clustering.docdistance.CosineDocDistance;
import dragon.ir.index.IRDoc;
import dragon.ir.index.IndexReader;
import dragon.ir.index.sentence.OnlineSentenceIndexReader;
import dragon.ir.index.sentence.OnlineSentenceIndexer;
import dragon.ir.kngbase.DocRepresentation;
import dragon.ir.summarize.LexRankSummarizer;
import dragon.matrix.DoubleSparseMatrix;
import dragon.matrix.vector.DoubleVector;
import dragon.onlinedb.CollectionReader;
import java.util.ArrayList;

public class ClusterLexRankSummarizer
extends LexRankSummarizer {
    protected ClusterModel clusterModel;
    private int clusterNum;

    public static ClusterLexRankSummarizer getClusterLexRankSummarizer(ConfigureNode node) {
        boolean tfidf = node.getBoolean("tfidf", true);
        boolean continuous = node.getBoolean("continuousscore", true);
        double similarityThreshold = node.getDouble("similaritythreshold");
        int clusterNum = node.getInt("clusternum");
        int indexerID = node.getInt("onlinesentenceindexer");
        OnlineSentenceIndexer indexer = (OnlineSentenceIndexer)new IndexerConfig().getIndexer(node, indexerID);
        ClusterLexRankSummarizer summarizer = new ClusterLexRankSummarizer(indexer, tfidf, clusterNum);
        summarizer.setContinuousScoreOpiton(continuous);
        summarizer.setSimilarityThreshold(similarityThreshold);
        return summarizer;
    }

    public ClusterLexRankSummarizer(OnlineSentenceIndexer indexer, int clusterNum) {
        super(indexer);
        this.clusterNum = clusterNum;
    }

    public ClusterLexRankSummarizer(OnlineSentenceIndexer indexer, boolean useTFIDF, int clusterNum) {
        super(indexer, useTFIDF);
        this.clusterNum = clusterNum;
    }

    @Override
    public String summarize(CollectionReader collectionReader, int maxLength) {
        this.collectionReader = collectionReader;
        this.indexReader = new OnlineSentenceIndexReader(this.indexer, collectionReader);
        this.indexReader.initialize();
        ArrayList sentSet = this.getSentenceSet(this.indexReader);
        IRDoc[] arrDoc = new IRDoc[sentSet.size()];
        for (int i = 0; i < arrDoc.length; ++i) {
            arrDoc[i] = (IRDoc)sentSet.get(i);
        }
        DoubleVector vector = this.powerMethod.getEigenVector(this.buildWeightMatrix(sentSet));
        BasicKMean kmean = new BasicKMean((IndexReader)this.indexReader, this.clusterModel, this.clusterNum);
        kmean.setMaxIteration(50);
        kmean.setRandomSeed(100L);
        kmean.setShowProgress(false);
        kmean.cluster();
        String summary = this.buildSummary(this.indexReader, sentSet, maxLength, vector, kmean.getClusterSet());
        this.indexReader.close();
        this.distanceMetric = null;
        this.clusterModel = null;
        return summary;
    }

    @Override
    protected double computeSimilarity(IRDoc firstSent, IRDoc secondSent) {
        if (this.distanceMetric == null) {
            if (this.useTFIDF) {
                DocRepresentation docRepresentation = new DocRepresentation(this.indexReader);
                docRepresentation.setMessageOption(false);
                DoubleSparseMatrix matrix = docRepresentation.genTFIDFMatrix();
                this.distanceMetric = new CosineDocDistance(matrix);
                this.clusterModel = new CosineClusterModel(this.clusterNum, matrix);
            } else {
                this.distanceMetric = new CosineDocDistance(this.indexReader.getDocTermMatrix());
                this.clusterModel = new CosineClusterModel(this.clusterNum, this.indexReader.getDocTermMatrix());
            }
        }
        return 1.0 - this.distanceMetric.getDistance(firstSent, secondSent);
    }
}

